﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include "vi_LayerHolder.h"
#include "vi_ObjectManager.h"

#define NN_VI_REQUIRES_LAYER_VALID(pLayer) \
    NN_SDK_REQUIRES_NOT_NULL(pLayer);      \
    NN_SDK_REQUIRES(ObjectManager::FindValidLayerHolder(pLayer) != ObjectManager::GetValidLayerHolderList()->end(), "Layer is not valid.");


namespace nn{ namespace vi{

    LayerId GetLayerIdWithValidation(const Layer* pLayer) NN_NOEXCEPT;

    namespace {
        NN_FORCEINLINE LayerHolder* GetLayerHolder(Layer* pLayer) NN_NOEXCEPT
        {
            return reinterpret_cast<LayerHolder*>(pLayer);
        }

        NN_FORCEINLINE const LayerHolder* GetLayerHolder(const Layer* pLayer) NN_NOEXCEPT
        {
            return reinterpret_cast<const LayerHolder*>(pLayer);
        }

        NN_FORCEINLINE LayerId GetLayerId(const Layer* pLayer) NN_NOEXCEPT
        {
            auto pHolder = GetLayerHolder(pLayer);
            return pHolder->GetId();
        }
    }
}}
