﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/vi_IndirectProducer.private.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/vi/detail/vi_SystemServiceProxy.private.h>
#include <nn/vi/detail/vi_ServiceReferenceHolder.h>
#include <nn/vi/detail/vi_IndirectLayerImpl.h>

namespace nn{ namespace vi{

    namespace {
        detail::SystemServiceProxy g_Proxy;
    }

    nn::Result InitializeForIndirectProducer() NN_NOEXCEPT
    {
        NN_RESULT_DO(g_Proxy.InitializeIndirectDisplay());
        detail::ServiceReferenceHolder::SetApplicationService(g_Proxy.GetApplicationDisplayService());
        detail::ServiceReferenceHolder::SetSystemService(g_Proxy.GetSystemDisplayService());
        detail::ServiceReferenceHolder::SetIndirectLayerTable(g_Proxy.GetIndirectLayerTable());
        NN_RESULT_SUCCESS;
    }

    void FinalizeForIndirectProducer() NN_NOEXCEPT
    {
        detail::ServiceReferenceHolder::ResetApplicationService();
        detail::ServiceReferenceHolder::ResetSystemService();
        detail::ServiceReferenceHolder::ResetIndirectLayerTable();
        g_Proxy.Finalize();
    }

    nn::Result OpenIndirectLayer(IndirectLayer** pOutLayer, IndirectProducerHandleType handle) NN_NOEXCEPT
    {
        NN_VI_GET_SYSTEM_SERVICE(pService);
        NN_VI_GET_INDIRECT_LAYER_TABLE(pTable);
        NN_RESULT_DO(detail::IndirectLayerImpl::OpenIndirectLayer(pOutLayer, handle, pService, pTable));
        NN_RESULT_SUCCESS;
    }

    static nn::Result CloseIndirectLayerImpl(IndirectLayer* pLayer) NN_NOEXCEPT
    {
        NN_VI_GET_SYSTEM_SERVICE(pService);
        NN_VI_GET_INDIRECT_LAYER_TABLE(pTable);
        NN_RESULT_DO(detail::IndirectLayerImpl::CloseIndirectLayer(pLayer, pService, pTable));
        NN_RESULT_SUCCESS;
    }

    void CloseIndirectLayer(IndirectLayer* pLayer) NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(CloseIndirectLayerImpl(pLayer));
    }

    nn::Result GetIndirectLayerNativeWindow(NativeWindowHandle* pOutNativeWindow, IndirectLayer* pLayer) NN_NOEXCEPT
    {
        NN_VI_GET_INDIRECT_LAYER_TABLE(pTable);
        NN_RESULT_DO(detail::IndirectLayerImpl::GetNativeWindow(pOutNativeWindow, pLayer, pTable));
        NN_RESULT_SUCCESS;
    }

    nn::Result FlipIndirectLayer(IndirectLayer* pLayer) NN_NOEXCEPT
    {
        NN_RESULT_THROW(ResultNotReady());
    }

}}
