﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/manager/vi_ManagerSharedLayer.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#define NN_VI_MNGR_CALLM(pService, Invoke)   \
    NN_ABORT_UNLESS_RESULT_SUCCESS(pService->GetManagerDisplayService()-> Invoke)

namespace nn{ namespace vi{ namespace manager{

    ManagerSharedLayer::ManagerSharedLayer() NN_NOEXCEPT
        : m_pService()
        , m_Handle()
        , m_pAttachedLowLevelLayer()
    {
    }

    bool ManagerSharedLayer::IsInitialized() const NN_NOEXCEPT
    {
        return m_pService != nullptr;
    }

    bool ManagerSharedLayer::IsAttached() const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        return m_pAttachedLowLevelLayer != nullptr;
    }

    nn::vi::fbshare::SharedLayerHandle ManagerSharedLayer::GetHandle() const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        return m_Handle;
    }

    //-------------------------------------------------------

    void ManagerSharedLayer::Initialize(
        nn::vi::manager::DisplayManagerService* pService,
        nn::applet::AppletResourceUserId userAruid
    ) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(!IsInitialized());

        nn::vi::fbshare::SharedLayerHandle hLayer = {};
        NN_VI_MNGR_CALLM(pService, CreateSharedLayer(&hLayer, userAruid));

        m_pService = pService;
        m_Handle = hLayer;
        m_pAttachedLowLevelLayer = nullptr;
    }

    void ManagerSharedLayer::Finalize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());

        NN_VI_MNGR_CALLM(m_pService, DestroySharedLayer(m_Handle));

        m_pService = nullptr;
        m_Handle = {};
        m_pAttachedLowLevelLayer = nullptr;
    }

}}}
