﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/usb/usb_Result.h>

#include "usb_PmServiceImpl.h"
#include "usb_Pm.h"

using namespace nn::sf;

namespace nn {
namespace usb {
namespace pm {

PmServiceImpl::PmServiceImpl(Pm *pPm) NN_NOEXCEPT
    : m_pPm(pPm)
    , m_PowerEvent(nn::os::EventClearMode_ManualClear, true)
    , m_DataEvent(nn::os::EventClearMode_ManualClear, true)
{
    m_pPm->BindPowerEvent(&m_PowerEvent);
    m_pPm->BindDataEvent(&m_DataEvent);
}

PmServiceImpl::~PmServiceImpl() NN_NOEXCEPT
{
    m_pPm->UnbindPowerEvent(&m_PowerEvent);
    m_pPm->UnbindDataEvent(&m_DataEvent);
}

Result PmServiceImpl::GetPowerEvent(Out<NativeHandle> eventHandle) NN_NOEXCEPT
{
    eventHandle.Set(NativeHandle(m_PowerEvent.GetReadableHandle(), false));

    return ResultSuccess();
}

Result PmServiceImpl::GetPowerState(OutBuffer state) NN_NOEXCEPT
{
    size_t   size   = state.GetSize();
    char    *buffer = state.GetPointerUnsafe();

    if (size < sizeof(UsbPowerState))
    {
        return ResultBufferSizeError();
    }

    return m_pPm->GetPowerState(reinterpret_cast<UsbPowerState*>(buffer), &m_PowerEvent);
}
Result PmServiceImpl::GetDataEvent(Out<NativeHandle> eventHandle) NN_NOEXCEPT
{
    eventHandle.Set(NativeHandle(m_DataEvent.GetReadableHandle(), false));

    return ResultSuccess();
}

Result PmServiceImpl::GetDataRole(Out<UsbDataRole> role) NN_NOEXCEPT
{
    return m_pPm->GetDataRole(role.GetPointer(), &m_DataEvent);
}

Result PmServiceImpl::SetDiagData(DiagData data, uint32_t value) NN_NOEXCEPT
{
#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
    detail::SetDiagData(data, value);
#endif

    return ResultSuccess();
}

Result PmServiceImpl::GetDiagData(DiagData data, nn::sf::Out<uint32_t> pOutValue) NN_NOEXCEPT
{
#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
    *pOutValue = detail::GetDiagData(data);
#endif

    return ResultSuccess();
}

} // end of namespace pm
} // end of namespace usb
} // end of namespace nn
