﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/usb/usb_ResultPrivate.h>
#include "../detail/usb_Complex.h"

namespace nn {
namespace usb {
namespace pm {

class Pm;

class PmPort
{
public:
    PmPort() NN_NOEXCEPT
        : m_pPm(nullptr)
        , m_pComplex(nullptr)
        , m_PortNumber(0)
        , m_IsEnabled(false)
        , m_Capability(0)
        , m_HsLane(0)
        , m_SsLane(0)
        , m_UfpCount(0)
        , m_DfpCount(0)
        , m_DisabledCount(0)
        , m_DataRole(DataRole_Unknown)
    {
    }

    ~PmPort() NN_NOEXCEPT
    {
    }

    Result Initialize(Pm *pPm, uint32_t portNumber, detail::UsbComplex *pComplex) NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;

    Result Enable() NN_NOEXCEPT;
    Result EnableAsHost() NN_NOEXCEPT;
    Result EnableAsDevice() NN_NOEXCEPT;
    Result Disable() NN_NOEXCEPT;
    void   ResetRole() NN_NOEXCEPT;

    bool   IsDualRole() const NN_NOEXCEPT;

private:
    Pm                     *m_pPm;
    detail::UsbComplex     *m_pComplex;

    uint32_t                m_PortNumber;
    bool                    m_IsEnabled;
    uint32_t                m_Capability;
    uint32_t                m_HsLane;
    uint32_t                m_SsLane;

    uint32_t                m_UfpCount;
    uint32_t                m_DfpCount;
    uint32_t                m_DisabledCount;

    enum DataRole
    {
        DataRole_Unknown,
        DataRole_Host,
        DataRole_Device,
    };

    DataRole                m_DataRole;
};

} // end of namespace pm
} // end of namespace usb
} // end of namespace nn
