﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/lmem/lmem_ExpHeap.h>

#include <nn/sf/impl/sf_StaticOneAllocator.h>
#include <nn/sf/impl/sf_ExpHeapAllocator.h>

#include "../detail/usb_IPdManager.h"
#include "../detail/usb_IPdSession.h"

namespace nn { namespace usb { namespace pd { namespace server {

// IPdManager 実装クラス
class PdManagerImpl
    : public nn::sf::ISharedObject
{

public:

    PdManagerImpl() NN_NOEXCEPT;
    ~PdManagerImpl() NN_NOEXCEPT;
    nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::usb::pd::detail::IPdSession>> outSession) NN_NOEXCEPT;

private:

    // OpenSession / OpenSessionForDev 用アロケータとして、
    // stateful な nn::sf::ExpHeapAllocator を使用する。
    typedef nn::sf::ExpHeapAllocator MyAllocator;
    MyAllocator m_Allocator;
    std::aligned_storage<4 * 1024>::type m_HeapBuffer;

    nn::lmem::HeapHandle m_HeapHandle;

    class PdSessionImpl;
};


}}}}
