﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/lmem/lmem_ExpHeap.h>

#include <nn/sf/impl/sf_StaticOneAllocator.h>
#include <nn/sf/impl/sf_ExpHeapAllocator.h>

#include "../detail/usb_IPdCradleManager.h"
#include "../detail/usb_IPdCradleSession.h"

namespace nn { namespace usb { namespace pd { namespace server {

// IPdManager 実装クラス
class PdCradleManagerImpl
    : public nn::sf::ISharedObject
{

public:

    PdCradleManagerImpl() NN_NOEXCEPT;
    ~PdCradleManagerImpl() NN_NOEXCEPT;
    nn::Result OpenCradleSession(nn::sf::Out<nn::sf::SharedPointer<nn::usb::pd::detail::IPdCradleSession>> outSession) NN_NOEXCEPT;

private:

    // OpenSession 用アロケータとして、
    // stateful な nn::sf::ExpHeapAllocator を使用する。
    typedef nn::sf::ExpHeapAllocator MyAllocator;
    MyAllocator m_Allocator;
    std::aligned_storage<8 * 1024>::type m_HeapBuffer;

    nn::lmem::HeapHandle m_HeapHandle;

    class PdCradleSessionImpl;
};


}}}}
