﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>

#include "usb_PdResult.h"

namespace nn{
namespace usb{
namespace pd{
namespace driver {
namespace detail{

Result GetStatus1LastCommandResult( Status1 status1 ) NN_NOEXCEPT
{
    switch ( status1.Get<Status1::LastCommand>() )
    {
    case Status1LastCommand_Aborted:
        return ResultPdcCommandAborted();
        break;

    case Status1LastCommand_Invalid:
        return ResultPdcCommandInvalid();
        break;

    case Status1LastCommand_Rejected:
        return ResultPdcCommandRejected();
        break;

    case Status1LastCommand_Terminated:
        return ResultPdcCommandTerminated();
        break;

    default:
        return ResultSuccess();
        break;
    }
}

Result GetStatus1InternalErrorResult( Status1 status1 ) NN_NOEXCEPT
{
    switch ( status1.Get<Status1::InternalErrors>() )
    {
    case Status1InternalError_OvpOvloOcp:
        return ResultPdcOvpOvloOcp();
        break;

    case Status1InternalError_UnexpectedError:
    case Status1InternalError_Reserved:
        return ResultPdcUnexpectedError();
        break;

    default:
        return ResultSuccess();
        break;
    }
}

} // detail
} // driver
} // pd
} // usb
} // nn
