﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <cstring>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os.h>
#include <nn/util/util_BitPack.h>

#include "usb_PdDriver.h"

namespace nn{
namespace usb{
namespace pd{
namespace driver {
namespace detail{

bool Driver::EnableOnCopper() NN_NOEXCEPT
{
    Result result;

    if( IsBatterySupported() )
    {
        return false;
    }

    USBPD_DBG_LOG("Enable on Copper\n");

    // 電力取得
    if ( !GetPowerOnCopper() )
    {
        return false;
    }

    return true;
}

bool Driver::GetPowerOnCopper() NN_NOEXCEPT
{
    Result result;

    result = ReceiveCommand1( &m_CurrentPdo, L1CommandSize_CurrentPdo, L1Command_CurrentPdo );
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    int voltage = m_CurrentPdo.Get<Pdo::Voltage>() * PdoMilliVoltUnit;
    NN_UNUSED(voltage);
    int maxAmpere = m_CurrentPdo.Get<Pdo::MaximumCurrent>() * PdoMilliAmpereUnit;
    NN_UNUSED(maxAmpere);
    USBPD_DBG_LOG("CurrentPDO::Voltage = %d mV, MaximumCurrent = %d mA\n", voltage, maxAmpere );
    result = ReceiveCommand1( &m_CurrentRdo, L1CommandSize_CurrentRdo, L1Command_CurrentRdo );
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    int a = m_CurrentRdo.Get<Rdo::OperatingCurrent>() * RdoMilliAmpereUnit;
    NN_UNUSED(a);
    int ma = m_CurrentRdo.Get<Rdo::MaximumOperatingCurrent>() * RdoMilliAmpereUnit;
    NN_UNUSED(ma);
    USBPD_DBG_LOG("CurrentRDO::OperatingCurrent = %d mA, MaximumCurrent = %d mA\n", a, ma );

    return true;
}

} // detail
} // driver
} // pd
} // usb
} // nn
