﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <cstdio>
#include <cstring>
#include <mutex>
#include <atomic>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/util/util_FormatString.h>

#include <nn/os.h>
#include <nn/os/os_SdkThreadCommon.h>
#include <nn/os/os_Thread.h>
#include <nn/os/os_InterruptEvent.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_MemoryFence.h>

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/impl/sf_StaticOneAllocator.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_NativeHandle.h>

#include <nn/dd.h>
#include <nn/pcv/pcv.h>

#include <nn/usb/usb_Limits.h>
#include <nn/usb/usb_Types.h>
#include <nn/usb/usb_ResultPrivate.h>
#include <nn/usb/usb_HostTypes.h>
#include <nn/usb/hs/sfdl/usb_HsClientEpSession.sfdl.h>
#include <nn/usb/hs/sfdl/usb_HsClientIfSession.sfdl.h>
#include <nn/usb/hs/sfdl/usb_HsClientRootSession.sfdl.h>

#include "../detail/usb_IoVaManager.h"
#include "../detail/usb_Memory.h"
#include "../detail/usb_Util.h"
#include "../detail/usb_Controller.h"
#include "../detail/usb_Complex.h"
#include "../detail/usb_Platform.h"

#include "usb_HsCh11.h"
#include "usb_HsSafeHandleManager.h"
#include "usb_HsLocalEvent.h"
#include "usb_HsDeferredRequest.h"
#include "usb_HsPrivateTypes.h"
#include "usb_HsFsm.h"
#include "usb_HsPlatformController.h"
#include "usb_HsClientEpSession.h"
#include "usb_HsClientIfSession.h"
#include "usb_HsClientRootSession.h"
#include "usb_HsUrb.h"
#include "usb_HsHostControllerDriver.h"
#include "usb_HsControlTransferManager.h"
#include "usb_HsDeviceManager.h"
#include "usb_HsDevice.h"
#include "usb_HsHubDevice.h"
#include "usb_HsServiceManager.h"
#include "usb_HsUtil.h"
#include "usb_Hs.h"
#include "usb_HsXhciDriver.h"

#if defined NN_USB_TEGRA_21X_SOC
#include "../detail/usb_ComplexTegra21x.h"
#include "usb_HsPlatformController30-soc.tegra.h"
#endif
