﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.usb
{
    [CppRefPath(@"<nn/usb/usb_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct UsbEndpointDirection{}
    [CppRefPath(@"<nn/usb/usb_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct UsbEndpointType{}
    [CppRefPath(@"<nn/usb/usb_Types.h>")]
    [ExternalStruct(7, 1)]
    public struct UsbEndpointDescriptor{}
    [CppRefPath(@"<nn/usb/usb_HostTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct InterfaceHandle{}
    [CppRefPath(@"<nn/usb/usb_HostTypes.h>")]
    [ExternalStruct(16, 2)]
    public struct DeviceFilter{}
    [CppRefPath(@"<nn/usb/usb_HostTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct EndpointNumber{}
    [CppRefPath(@"<nn/usb/usb_HostTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct FrameNumber{}
    [CppRefPath(@"<nn/usb/usb_HostTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct DeviceUid{}
    [CppRefPath(@"<nn/usb/usb_HostTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct SchedulePolicy{}
    [CppRefPath(@"<nn/usb/usb_HostTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct TestMode{}
}

namespace nn.usb.hs
{
    [CppRefPath(@"<nn/usb/hs/sfdl/usb_HsClientEpSession.sfdl.h>")]
    public interface IClientEpSession : IServiceObject
    {
        [MethodId(0)]
        Result ReOpen();

        [MethodId(1)]
        Result Close();

        [MethodId(2)]
        Result GetCompletionEvent(Out<NativeHandle> eventHandle);

        [MethodId(3)]
        Result PopulateRing();

        [MethodId(4)]
        Result PostBufferAsync(Out<uint32_t>  pXferId,
                               uint64_t       address,
                               uint32_t       bytes,
                               uint64_t       context);

        [MethodId(5)]
        Result GetXferReport(Out<uint32_t>    pOutCount,
                             [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] OutBuffer        buffer,
                             uint32_t         count);

        [MethodId(6)]
        Result BatchBufferAsync(Out<uint32_t>     pXferId,
                                uint64_t          address,
                                [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] InBuffer          sizeArray,
                                uint32_t          xferCount,
                                uint64_t          context,
                                SchedulePolicy    policy,
                                uint32_t          frameId);

        [MethodId(7)]
        Result CreateSmmuSpace(uint64_t address, uint32_t size);

        [MethodId(8)]
        Result ShareReportRing(NativeHandle ringHandle, uint32_t size);
    }

    [CppRefPath(@"<nn/usb/hs/sfdl/usb_HsClientIfSession.sfdl.h>")]
    public interface IClientIfSession : IServiceObject
    {
        [MethodId(0)]
        Result GetStateChangeEvent(Out<NativeHandle> eventHandler);

        [MethodId(1)]
        Result SetInterface(uint8_t bAlternateSetting, OutBuffer dataOut);

        [MethodId(2)]
        Result GetInterface(OutBuffer dataOut);

        [MethodId(3)]
        Result GetAlternateInterface(uint8_t bAlternateSetting, OutBuffer dataOut);

        [MethodId(4)]
        Result GetCurrentFrame(Out<FrameNumber> outFrameNumber);

        [MethodId(5)]
        Result CtrlXferAsync(uint8_t       bmRequestType,
                             uint8_t       bRequest,
                             uint16_t      wValue,
                             uint16_t      wIndex,
                             uint16_t      wLength,
                             uint64_t      procVa);

        [MethodId(6)]
        Result GetCtrlXferCompletionEvent(Out<NativeHandle> eventHandle);

        [MethodId(7)]
        Result GetCtrlXferReport(OutBuffer buffer);

        [MethodId(8)]
        Result ResetDevice();

        [MethodId(9)]
        Result OpenUsbEp(UsbEndpointType            epType,
                         EndpointNumber             epNumber,
                         UsbEndpointDirection       epDirection,
                         uint16_t                   maxUrb,
                         uint32_t                   maxXferSize,
                         Out<UsbEndpointDescriptor> outDescriptor,
                         Out<IClientEpSession>      outSession);
    }

    [CppRefPath(@"<nn/usb/hs/sfdl/usb_HsClientRootSession.sfdl.h>")]
    public interface IClientRootSession : IServiceObject
    {
        [MethodId(0)]
        Result BindClientProcess(NativeHandle processHandle);

        [MethodId(1)]
        Result QueryAllInterfaces(Out<int32_t> outIfCount, OutBuffer output, DeviceFilter deviceFilter);

        [MethodId(2)]
        Result QueryAvailableInterfaces(Out<int32_t> outIfCount, OutBuffer output, DeviceFilter deviceFilter);

        [MethodId(3)]
        Result QueryAcquiredInterfaces(Out<int32_t> outIfCount, OutBuffer output);

        [MethodId(4)]
        Result CreateInterfaceAvailableEvent(Out<NativeHandle> eventHandle, uint8_t filterIndex, DeviceFilter deviceFilter);

        [MethodId(5)]
        Result DestroyInterfaceAvailableEvent(uint8_t filterIndex);

        [MethodId(6)]
        Result GetInterfaceStateChangeEvent(Out<NativeHandle> eventHandle);

        [MethodId(7)]
        Result AcquireUsbIf(InterfaceHandle ifHandle, Out<IClientIfSession> outSession, OutBuffer deviceProfile, OutBuffer interfaceProfile);

        [MethodId(8)]
        Result SetTestMode(uint32_t port, TestMode mode, int32_t offset, Out<uint32_t> outStrength);
    }
}
