﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    usb_DsStringTable.h
 *
 * @brief   USB Device Stack String Table Container
 */

#include "usb_DsCommon.h"

namespace nn {
namespace usb {
namespace ds {

const int StringTableEntries = 16;

class DsProtocol;

class DsStringTable
{
public:
    DsStringTable() NN_NOEXCEPT {}
    ~DsStringTable() NN_NOEXCEPT {}

    Result  Initialize() NN_NOEXCEPT;
    Result  Finalize() NN_NOEXCEPT;

    Result  ClearData() NN_NOEXCEPT;
    Result  AddUsbStringDescriptor(UsbStringDescriptor *pUsbStringDescriptor, uint8_t *pIndex) NN_NOEXCEPT;
    Result  DeleteUsbStringDescriptor(uint8_t index) NN_NOEXCEPT;
    UsbStringDescriptor *GetUsbStringDescriptor(uint8_t index) NN_NOEXCEPT;

private:

    UsbStringDescriptor m_UsbStringDescriptor[StringTableEntries];
};

} // end of namespace ds
} // end of namespace usb
} // end of namespace nn
