﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//#define NN_USB_ENABLE_TRACE 1

#include "usb_DsDescriptor.h"
#include "usb_DsStringTable.h"
#include "usb_DsProtocol.h"

#undef  NN_USB_TRACE_CLASS_NAME
#define NN_USB_TRACE_CLASS_NAME "DsStringTable"

using namespace nn::usb;

namespace nn {
namespace usb {
namespace ds {
//////////////////////////////////////////////////////////////////////////////
// Public Methods
//////////////////////////////////////////////////////////////////////////////
Result DsStringTable::Initialize() NN_NOEXCEPT
{
    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result DsStringTable::Finalize() NN_NOEXCEPT
{
    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result DsStringTable::ClearData() NN_NOEXCEPT
{
    memset(m_UsbStringDescriptor, 0, sizeof(m_UsbStringDescriptor));

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result DsStringTable::AddUsbStringDescriptor(UsbStringDescriptor *pUsbStringDescriptor, uint8_t *pIndex) NN_NOEXCEPT
{
    Result result = ResultImplementationLimit();

    if (pUsbStringDescriptor->bLength <= sizeof(UsbStringDescriptor))
    {
        for (uint8_t i = 0; i < StringTableEntries; i++)
        {
            if (m_UsbStringDescriptor[i].bLength == 0)
            {
                memcpy(&m_UsbStringDescriptor[i], pUsbStringDescriptor, sizeof(UsbStringDescriptor));
                *pIndex = i;
                result = ResultSuccess();

                break;
            }
        }
    }

    return result;
}


//////////////////////////////////////////////////////////////////////////////
Result DsStringTable::DeleteUsbStringDescriptor(uint8_t index) NN_NOEXCEPT
{
    Result result = ResultInvalidParameter();

    if (index < StringTableEntries)
    {
        if (m_UsbStringDescriptor[index].bLength)
        {
            memset(&m_UsbStringDescriptor[index], 0, sizeof(UsbStringDescriptor));

            result = ResultSuccess();
        }
    }

    return result;
}


//////////////////////////////////////////////////////////////////////////////
UsbStringDescriptor *DsStringTable::GetUsbStringDescriptor(uint8_t index) NN_NOEXCEPT
{
    if (index < StringTableEntries)
    {
        if ((m_UsbStringDescriptor[index].bLength >= 2) && ((m_UsbStringDescriptor[index].bLength & 1) == 0))
        {
            return &m_UsbStringDescriptor[index];
        }
    }

    return NULL;
}


//////////////////////////////////////////////////////////////////////////////
} // end of namespace ds
} // end of namespace usb
} // end of namespace nn
