﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "usb_DsCommon.h"
#include "usb_DsInterfaceImpl.h"

#include "../detail/usb_Platform.h"

namespace nn {
namespace usb {
namespace ds {

class DsServiceImpl : public nn::sf::ISharedObject
{
public:
    explicit DsServiceImpl(detail::UsbPlatform *pPlatform) NN_NOEXCEPT;
    ~DsServiceImpl() NN_NOEXCEPT;

    Result BindComplex(ComplexId complexId) NN_NOEXCEPT;
    Result BindClientProcess(nn::sf::NativeHandle processHandle) NN_NOEXCEPT;
    Result RegisterInterface(nn::sf::Out<nn::sf::SharedPointer<IDsInterface>> pInterface, uint8_t bInterfaceNumber) NN_NOEXCEPT;
    Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;
    Result GetState(nn::sf::Out<UsbState> state) NN_NOEXCEPT;

    Result ClearDeviceData() NN_NOEXCEPT;
    Result AddUsbStringDescriptor(nn::sf::Out<uint8_t>index, nn::sf::InBuffer pUsbDeviceDescriptor) NN_NOEXCEPT;
    Result DeleteUsbStringDescriptor(uint8_t index) NN_NOEXCEPT;
    Result SetUsbDeviceDescriptor(nn::sf::InBuffer pUsbDeviceDescriptor, UsbDeviceSpeed usbbDeviceSpeed) NN_NOEXCEPT;
    Result SetBinaryObjectStore(nn::sf::InBuffer pBinaryObjectStore) NN_NOEXCEPT;

    Result Enable() NN_NOEXCEPT;
    Result Disable() NN_NOEXCEPT;

    void OnAddInterface(uint8_t ifNum, DsInterfaceImpl *pInterface) NN_NOEXCEPT;
    void OnDelInterface(uint8_t ifNum) NN_NOEXCEPT;

private:
    detail::UsbPlatform                    *m_pPlatform;
    DsProtocol                             *m_pProtocol;
    DsInterfaceImpl                        *m_pInterface[DsLimitMaxInterfacesPerConfigurationCount];

    nn::os::SystemEvent                     m_StateChangeEvent;

    nn::sf::NativeHandle                    m_ProcessHandle;

private:
    void UnbindComplex() NN_NOEXCEPT;
    void UnbindClientProcess() NN_NOEXCEPT;
};



} // end of namespace hs
} // end of namespace usb
} // end of namespace nn

