﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "usb_DsCommon.h"
#include "usb_DsProtocol.h"
#include "usb_DsEndpointImpl.h"

namespace nn {
namespace usb {
namespace ds {

class DsServiceImpl;

class DsInterfaceImpl : public nn::sf::ISharedObject
{
public:
    DsInterfaceImpl(DsProtocol                   *pProtocol,
                    DsServiceImpl                *pService,
                    uint8_t                       bInterfaceNumber,
                    nn::dd::ProcessHandle         processHandle) NN_NOEXCEPT;
    ~DsInterfaceImpl() NN_NOEXCEPT;

    Result AppendConfigurationData(uint8_t bInterfaceNumber, UsbDeviceSpeed usbDeviceSpeed, nn::sf::InBuffer pData) NN_NOEXCEPT;
    Result RegisterEndpoint(uint8_t bEndpointAddress, nn::sf::Out<nn::sf::SharedPointer<IDsEndpoint>> pEndpoint) NN_NOEXCEPT;
    Result GetSetupEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;
    Result GetSetupPacket(nn::sf::OutBuffer setup) NN_NOEXCEPT;

    Result Enable() NN_NOEXCEPT;
    Result Disable() NN_NOEXCEPT;

    Result CtrlInAsync(nn::sf::Out<uint32_t>   pOutUrbId,
                       uint64_t                address,
                       uint32_t                bytes) NN_NOEXCEPT;

    Result CtrlOutAsync(nn::sf::Out<uint32_t>   pOutUrbId,
                        uint64_t                address,
                        uint32_t                bytes) NN_NOEXCEPT;

    Result GetCtrlInCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;
    Result GetCtrlInUrbReport(nn::sf::Out<UrbReport> report) NN_NOEXCEPT;

    Result GetCtrlOutCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;
    Result GetCtrlOutUrbReport(nn::sf::Out<UrbReport> report) NN_NOEXCEPT;

    Result CtrlStall() NN_NOEXCEPT;

    void   OnAddEndpoint(uint8_t epAddress, DsEndpointImpl *pEndpoint) NN_NOEXCEPT;
    void   OnDelEndpoint(uint8_t epAddress) NN_NOEXCEPT;

    bool   IsEnabled() NN_NOEXCEPT;
    bool   IsParentOf(uint8_t epAddress) NN_NOEXCEPT;

private:
    nn::os::Mutex                         m_Mutex;

    bool                                  m_IsEnabled;

    DsProtocol                           *m_pProtocol;
    nn::sf::SharedPointer<DsServiceImpl>  m_pService;

    uint8_t                               m_IfNum;

    DsEndpointImpl                       *m_pEndpoint[UsbLimitMaxEndpointsCount];

    nn::os::SystemEvent                   m_SetupEvent;

    nn::dd::ProcessHandle                 m_ProcessHandle;
};

} // end of namespace ds
} // end of namespace usb
} // end of namespace nn
