﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    usb_DsInterfaceData.h
 *
 * @brief   USB Device Stack Interface Table Container
 */

#include "usb_DsCommon.h"

namespace nn {
namespace usb {
namespace ds {

const int MaxInterfaceDataSize = 128;

class DsProtocol;


class DsInterfaceData
{
public:
    DsInterfaceData() NN_NOEXCEPT {}
    ~DsInterfaceData() NN_NOEXCEPT {}

    Result  Initialize() NN_NOEXCEPT;
    Result  Finalize() NN_NOEXCEPT;

    Result  ClearData();
    Result  AppendConfigurationData(uint8_t bInterfaceNumber, UsbDeviceSpeed usbDeviceSpeed, uint8_t *pData, int bytes) NN_NOEXCEPT;
    Result  GetConfigurationData(uint8_t bInterfaceNumber, UsbDeviceSpeed usbDeviceSpeed, uint8_t *pDest, int *pSize) NN_NOEXCEPT;
    Result  SetReportData(uint8_t bInterfaceNumber, uint8_t *pData, int bytes) NN_NOEXCEPT;
    Result  GetReportData(uint8_t bInterfaceNumber, uint8_t *pDest, int *pSize) NN_NOEXCEPT;

private:

    uint8_t m_ConfigurationDataFullSpeed[DsLimitMaxInterfacesPerConfigurationCount][MaxInterfaceDataSize];
    uint8_t m_ConfigurationDataHighSpeed[DsLimitMaxInterfacesPerConfigurationCount][MaxInterfaceDataSize];
    uint8_t m_ConfigurationDataSuperSpeed[DsLimitMaxInterfacesPerConfigurationCount][MaxInterfaceDataSize];
    int     m_ConfiguratioDataSizeFullSpeed[DsLimitMaxInterfacesPerConfigurationCount];
    int     m_ConfiguratioDataSizeHighSpeed[DsLimitMaxInterfacesPerConfigurationCount];
    int     m_ConfiguratioDataSizeSuperSpeed[DsLimitMaxInterfacesPerConfigurationCount];

    // Report data, only support 1 entry of MaxInterfaceDataSize bytes, this covers most things
    uint8_t m_ReportDescriptor[DsLimitMaxInterfacesPerConfigurationCount][MaxInterfaceDataSize];
    int     m_ReportDescriptorSize[DsLimitMaxInterfacesPerConfigurationCount];
};

} // end of namespace ds
} // end of namespace usb
} // end of namespace nn
