﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    usb_Controller.h
 * @brief   USB Controller Abstraction
 */

#include <nn/os.h>
#include <nn/util/util_StringUtil.h>
#include <nn/usb/usb_Result.h>

#include "usb_Memory.h"
#include "usb_RegisterBlock.h"
#include "usb_SmmuMapManager.h"

namespace nn {
namespace usb {
namespace detail {

class UsbComplex;

class UsbController
{
public:
    struct RegisterConfig
    {
        uintptr_t basePhysicalAddress;
        size_t    size;
    };
    struct Config
    {
        SmmuMapManager*         pSmmu;
        const char*             pName;
        RegisterConfig          reg;
    };

    explicit UsbController(uint32_t capability) NN_NOEXCEPT
        : m_pComplex(nullptr)
        , m_IsEnabled(false)
        , m_Capability(capability)
    {
        memset(&m_Config, 0, sizeof(m_Config));
        // do nothing
    }

    virtual ~UsbController() NN_NOEXCEPT
    {
        // do nothing
    }

    virtual Result Initialize(UsbComplex* pComplex, Config* pConfig) NN_NOEXCEPT = 0;
    virtual Result Finalize() NN_NOEXCEPT = 0;

    virtual Result Enable() NN_NOEXCEPT = 0;
    virtual Result Disable() NN_NOEXCEPT = 0;

    bool           IsEnabled() NN_NOEXCEPT;
    uint32_t       GetCapability() NN_NOEXCEPT;
    int            GetName(char *pOutName, uint32_t maxSize) NN_NOEXCEPT;
    SmmuMapManager& DoSmmu() NN_NOEXCEPT;

    RegisterBlock  Register;

protected:
    UsbComplex*    m_pComplex;
    bool           m_IsEnabled;
    uint32_t       m_Capability;

private:
    Config         m_Config;
};

} // end of namespace detail
} // end of namespace usb
} // end of namespace nn
