﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/updater/updater.h>

namespace nn { namespace updater {

// ResolvePath に MountName を含むため、ここの API としている
const char* GetMountName() NN_NOEXCEPT;

// UpdateType に応じた BootImagePackage 内のパスを返す
const char* ResolveBctPath(BootImageUpdateType bootImageUpdateType) NN_NOEXCEPT;
const char* ResolvePackage1Path(BootImageUpdateType bootImageUpdateType) NN_NOEXCEPT;
const char* ResolvePackage2Path(BootImageUpdateType bootImageUpdateType) NN_NOEXCEPT;

// SecureInfo の扱い方
bool NeedsUpdateSecureInfo(BootImageUpdateType bootImageUpdateType) NN_NOEXCEPT;

}}
