﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "updater_BisAccessor.h"

namespace nn { namespace updater {

enum class BootPartition1Type
{
    BctNormalMain_BCT0,
    BctSafeMain_BCT1,
    BctNormalSub_BCT2,
    BctSafeSub_BCT3,
    BctRepairMain_BCT4,
    BctSave_BCT63,
    Package1NormalMain,
    Package1NormalSub,
    Eks
};

class BootPartition1Accessor : public TAccessor<BootPartition1Type>
{
    NN_DISALLOW_COPY(BootPartition1Accessor);

public:
    BootPartition1Accessor() NN_NOEXCEPT;

    // Bct を書き込む前に必ず呼ぶ必要がある
    Result UpdateSecureInfo(void* bctBuffer, size_t bctSize, const void* eksBuffer, size_t eksSize) NN_NOEXCEPT;

    // UpdateSecureInfo の、内部で eks 読み込みを自動で行う版
    Result UpdateSecureInfoAuto(void* bctBuffer, size_t bctSize, void* eksBuffer, size_t eksSize) NN_NOEXCEPT;

    // available APIs by parent class
    // Result Read(void* pOutBuffer, size_t* pOutSize, size_t bufferSize, TYPE type) NN_NOEXCEPT;
    // Result Write(const void* pData, size_t dataSize, TYPE type) NN_NOEXCEPT;
    // Result Invalidate(TYPE type) NN_NOEXCEPT

private:
    int32_t ReadBootLoaderVersion(void* buffer, size_t size) NN_NOEXCEPT;
    int32_t CalculateEksIndex(int32_t bootLoaderVersion) NN_NOEXCEPT;
    void CopyEks(void* bctBuffer, const void* eksBuffer, int32_t eksIndex) NN_NOEXCEPT;
};

enum class BootPartition2Type
{
    Package1SafeMain,
    Package1SafeSub,
    Package1RepairMain,
    Package1RepairSub
};

class BootPartition2Accessor : public TAccessor<BootPartition2Type>
{
    NN_DISALLOW_COPY(BootPartition2Accessor);

public:
    BootPartition2Accessor() NN_NOEXCEPT;

    // available APIs by parent class
    // Result Read(void* pOutBuffer, size_t* pOutSize, size_t bufferSize, TYPE type) NN_NOEXCEPT;
    // Result Write(const void* pData, size_t dataSize, TYPE type) NN_NOEXCEPT;
    // Result Invalidate(TYPE type) NN_NOEXCEPT
};

enum class Package2Index
{
    NormalMain,
    NormalSub,
    SafeMain,
    SafeSub,
    RepairMain,
    RepairSub
};

enum class Package2Type
{
    Package2,
};

class Package2Accessor : public TAccessor<Package2Type>
{
    NN_DISALLOW_COPY(Package2Accessor);

public:
    explicit Package2Accessor(Package2Index index) NN_NOEXCEPT;

    // available APIs by parent class
    // Result Read(void* pOutBuffer, size_t* pOutSize, size_t bufferSize, TYPE type) NN_NOEXCEPT;
    // Result Write(const void* pData, size_t dataSize, TYPE type) NN_NOEXCEPT;
    // Result Invalidate(TYPE type) NN_NOEXCEPT
};

}}
