﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <nn/os/os_SystemEvent.h>

#include <nn/uart/driver/uart.h>
#include <nn/uart/driver/uart_Suspend.h>

namespace nn {
namespace uart {
namespace driver {

void Initialize() NN_NOEXCEPT
{
}

bool IsInitialized() NN_NOEXCEPT
{
    return true;
}

void Finalize() NN_NOEXCEPT
{
}


bool HasPort(PortName name) NN_NOEXCEPT
{
    NN_UNUSED(name);
    return false;
}

bool HasPortForDev(int portIndex) NN_NOEXCEPT
{
    NN_UNUSED(portIndex);
    return false;
}

bool IsSupportedBaudRate(PortName name, BaudRate baudRate) NN_NOEXCEPT
{
    NN_UNUSED(name);
    NN_UNUSED(baudRate);
    return false;
}

bool IsSupportedBaudRateForDev(int portIndex, BaudRate baudRate) NN_NOEXCEPT
{
    NN_UNUSED(portIndex);
    NN_UNUSED(baudRate);
    return false;
}

bool IsSupportedFlowControlMode(PortName name, FlowControlMode flowControlMode) NN_NOEXCEPT
{
    NN_UNUSED(name);
    NN_UNUSED(flowControlMode);
    return false;
}

bool IsSupportedFlowControlModeForDev(int portIndex, FlowControlMode flowControlMode) NN_NOEXCEPT
{
    NN_UNUSED(portIndex);
    NN_UNUSED(flowControlMode);
    return false;
}

bool IsSupportedPortEvent(PortName name, PortEventType portEvent) NN_NOEXCEPT
{
    NN_UNUSED(name);
    NN_UNUSED(portEvent);
    return false;
}

bool IsSupportedPortEventForDev(int portIndex, PortEventType portEvent) NN_NOEXCEPT
{
    NN_UNUSED(portIndex);
    NN_UNUSED(portEvent);
    return false;
}

void InitializePortConfig(PortConfigType* pOutPortConfig, BaudRate baudRate,
        char* sendBuffer, size_t sendBufferLength,
        char* receiveBuffer, size_t receiveBufferLength) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutPortConfig);
    NN_SDK_REQUIRES(sendBuffer || receiveBuffer, "Either sendBuffer or receiveBuffer must not be null.\n");

    pOutPortConfig->_baudRate            = baudRate;
    pOutPortConfig->_flowControlMode     = FlowControlMode_None; // Default
    pOutPortConfig->_sendBuffer          = sendBuffer;
    pOutPortConfig->_sendBufferLength    = sendBuffer ? sendBufferLength : 0;
    pOutPortConfig->_receiveBuffer       = receiveBuffer;
    pOutPortConfig->_receiveBufferLength = receiveBuffer ? receiveBufferLength : 0;
}

void SetPortConfigFlowControlMode(PortConfigType* pPortConfig, FlowControlMode flowControlMode) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pPortConfig);
    pPortConfig->_flowControlMode = flowControlMode;
}

bool OpenPort(PortSession* pOutSession, PortName name, const PortConfigType& portConfig) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutSession);
    NN_UNUSED(name);
    NN_UNUSED(portConfig);
    return false;
}

bool OpenPortForDev(PortSession* pOutSession, int portIndex, const PortConfigType& portConfig) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutSession);
    NN_UNUSED(portIndex);
    NN_UNUSED(portConfig);
    return false;
}

bool IsPortOpen(int portIndex)
{
    NN_UNUSED(portIndex);
    return false;
}

size_t GetWritableLength(const PortSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return 0;
}

void Send(size_t* pOutDoneBytes, PortSession* pSession, const void* data, size_t dataBytes) NN_NOEXCEPT
{
    NN_UNUSED(pOutDoneBytes);
    NN_UNUSED(pSession);
    NN_UNUSED(data);
    NN_UNUSED(dataBytes);
}

size_t GetReadableLength(const PortSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return 0;
}

nn::Result Receive(size_t* pOutDoneBytes, void* outData, size_t dataBytes, PortSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pOutDoneBytes);
    NN_UNUSED(outData);
    NN_UNUSED(dataBytes);
    NN_UNUSED(pSession);
    return nn::ResultSuccess();
}

bool BindPortEvent(nn::os::SystemEventType* pEvent, PortSession* pSession, PortEventType eventType, size_t threshold) NN_NOEXCEPT
{
    NN_UNUSED(pEvent);
    NN_UNUSED(pSession);
    NN_UNUSED(eventType);
    NN_UNUSED(threshold);
    return false;
}

bool UnbindPortEvent(nn::os::SystemEventType* pEvent, PortSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pEvent);
    NN_UNUSED(pSession);
    return false;
}

void ClosePort(PortSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}

void SuspendAllPorts() NN_NOEXCEPT
{
}

void ResumeAllPorts() NN_NOEXCEPT
{
}

} // driver
} // uart
} // nn
