﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   UART ドライバで使われるユーティリティ
 */

#pragma once

#include <nn/os.h>

namespace nn {
namespace uart {
namespace driver {
namespace detail {

struct StaticMutex
{
    nn::os::MutexType mutex;
    void Initialize() NN_NOEXCEPT
    {
        nn::os::InitializeMutex(&mutex, false, 0);
    }
    void lock() NN_NOEXCEPT
    {
        nn::os::LockMutex(&mutex);
    }
    void unlock() NN_NOEXCEPT
    {
        nn::os::UnlockMutex(&mutex);
    }
};

} // detail
} // driver
} // uart
} // nn
