﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace uart {
namespace driver {
namespace detail {

/**
 * @brief   UART レジスタのアドレス、ビットマスクの情報
 *
 * @details レジスタアドレスはベースアドレスからのオフセットです。
 */
struct UartRegisterDefs
{
    uintptr_t   uartAddress;
};


#ifndef NN_BUILD_CONFIG_SPEC_NX
/**
 * @brief   UART 関連の CLK_RST レジスタのアドレス、ビットマスクの情報
 *
 * @details レジスタアドレスはベースアドレスからのオフセットです。
 */
struct ClkRstRegisterDefs
{
    uintptr_t   clockSourceAddress;
    uintptr_t   clockEnableAddress;
    uintptr_t   resetAddress;
    uint32_t    clockEnableBitMask;
    uint32_t    resetBitMask;
};
#endif

} // detail
} // driver
} // uart
} // nn

#if defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1)
    #include "uart_RegisterUart-hardware.jetson-tk1.h"
#elif defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined(NN_BUILD_CONFIG_SOC_TEGRA_X1)
    #include "uart_RegisterUart-soc.tegra-x1.h"
#else
    #error NN_BUILD_CONFIG_HARDWARE_ not selected or supported
#endif
