﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief   温度計測サービスのサーバに関する定義です。
 */

#include <nn/nn_Common.h>

#include <nn/sf/sf_Types.h>

#include <nn/ts/server/ts_IMeasurementServer.autogen.h>

namespace nn {
namespace ts {

//!< HIPC 使用時に温度計測サービスのプロクシを作成します。
::nn::sf::SharedPointer<server::IMeasurementServer> CreateMeasurementServerProxy() NN_NOEXCEPT;

} // ts
} // nn
