﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.ts
{
    [CppRefPath("<nn/ts/ts_Types.h>")]
    [ExternalStruct(8, 4)]
    public struct LimitTemperature
    {
    }
}

namespace nn.ts.server
{
    [CppRefPath("<nn/ts/server/ts_IMeasurementServer.sfdl-autogen.h>")]
    interface IMeasurementServer : IServiceObject
    {
        [MethodId(0)]
        Result GetTemperatureRange(Out<LimitTemperature> outLimitTemperature, uint8_t location);

        [MethodId(1)]
        Result GetTemperature(Out<int_t> outTemperature, uint8_t location);

        [MethodId(2)]
        Result SetMeasurementMode(uint8_t location, uint8_t measurementMode);

        [MethodId(3)]
        Result GetTemperatureMilliC(Out<int_t> outTemperatureMilliC, uint8_t location);
    }
}
