﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * NX の持つデバイスの宣言
 */

#include <nn/nn_Common.h>

#include <nn/ts/impl/ts.h>

namespace nn {
namespace ts {
namespace impl {
namespace detail {

enum Device
{
//    Devices_SocTherm,       // SOC_THERM (SoC)
    Devices_Tmp451Local,    // TMP451 Local (Thermal Sensor)
    Devices_Tmp451Remote,   // TMP451 Remote (Thermal Sensor)
//    Devices_Max17050,       // MAX17050 (FuelGauge)
};

// 計測位置の定義と内部の管理デバイスの組み合わせの構造体
struct LocationDeviceCombination
{
    Location    location;
    Device      device;
};

const LocationDeviceCombination LocationDeviceCombinationList[] =
{
//    { Location_SocCpu,                  Devices_SocTherm },
//    { Location_SocGpu,                  Devices_SocTherm },
//    { Location_SocPll,                  Devices_SocTherm },
//    { Location_SocMem,                  Devices_SocTherm },
    { Location_ThermalSensorInternal,   Devices_Tmp451Local },
    { Location_ThermalSensorExternal,   Devices_Tmp451Remote },
//    { Location_Battery,                 Devices_Max17050 },
};

const int NumberOfLocation = sizeof(LocationDeviceCombinationList) / sizeof(LocationDeviceCombinationList[0]);


} // detail
} // impl
} // ts
} // nn
