﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * tmp451 のデバイスコントローラ
 */

#include <nn/nn_Common.h>


#include <nn/ts/impl/ts.h>
#include <nnd/tmp451/tmp451.h>

#include "ts_SettingsHolder.h"
#include "ts_TargetSpec.h"

namespace nn {
namespace ts {
namespace impl {
namespace detail {

class Tmp451Controller
{
    NN_DISALLOW_COPY(Tmp451Controller);
    NN_DISALLOW_MOVE(Tmp451Controller);

private:
    Tmp451Controller() NN_NOEXCEPT:
        m_Initialized(false)
        {}

public:
    static Tmp451Controller& GetInstance() NN_NOEXCEPT
    {
        static Tmp451Controller instance;
        return instance;
    }

    nn::Result InitializeDevice() NN_NOEXCEPT;
    nn::Result FinalizeDevice() NN_NOEXCEPT;
    bool IsInitialized() NN_NOEXCEPT
    {
        return m_Initialized;
    }

    LimitTemperature GetTemperatureRange(nnd::tmp451::Location location) NN_NOEXCEPT;

    nn::Result GetTemperature(int* pOutTemperatureInteger, nnd::tmp451::Location location) NN_NOEXCEPT;
    nn::Result GetTemperatureMilliC(int* pOutTemperatureMilliCInteger, nnd::tmp451::Location location) NN_NOEXCEPT;

    nn::Result SetMeasurementMode(nnd::tmp451::MeasurementMode measurementMode) NN_NOEXCEPT;

//    void GetDetectionSettings(LimitTemperature* pOutLimit, nnd::tmp451::Location location) NN_NOEXCEPT;
//    void SetDetectionSettings(LimitTemperature limit, nnd::tmp451::Location location) NN_NOEXCEPT;
//    ExceededStatus GetDetectedStatus(nnd::tmp451::Location location) NN_NOEXCEPT;
//
//    nn::Result BindDetectionEvent(nn::os::SystemEventType* pOutEvent, nnd::tmp451::Location location) NN_NOEXCEPT;
//    void UnbindDetectionEvent(nnd::tmp451::Location location) NN_NOEXCEPT;
//    bool GetDetectionEventEnabled(Location location) NN_NOEXCEPT;
//    void SetDetectionEventEnabled(bool enable) NN_NOEXCEPT;

private:
    bool    m_Initialized;

    SettingsHolder m_SettingsHolder;
};


} // detail
} // impl
} // ts
} // nn
