﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "tmipc_defines.h"
#include "tmipc_thread.h"
#include "tmipc_list.h"

//==============================================================================
namespace tmipc {
//==============================================================================

class Node;
class Packet;
class Task;

class TaskList
{
protected:
        mutable Mutex       m_Mutex;
        List<Task>          m_Tasks[TMIPC_NUM_PRIORITIES];
        List<Task>          m_SleepingTasks[TMIPC_NUM_PRIORITIES];

private:

        Task*               FindTask                ( u32       TaskId ) const;
        void                RemoveTask              ( Task*     pTask );

public:
                            TaskList                ();
virtual                    ~TaskList                ();

        void                Init                    ();
        void                Kill                    ();

        void                AddTask                 ( Task*     pTask );
        void                CancelTask              ( u32       TaskId );
        void                CleanupFinishedTasks    ();
        bool                ProcessSendPacket       ( bool      IsConnected, Packet* pPacket );
        void                ProcessRecvPacket       ( Packet*   pPacket );

        // Removes all tasks from the TaskList parameter, and adds them to "this" TaskList.
        void                GoToSleep               ();
        void                WakeUp                  ();
        s32                 GetTaskCount            () const;
        s32                 GetSleepingTaskCount    () const;

        void                CancelAll               ();

        bool                IsTaskIdFree            ( u32       TaskId );
        void                PrintTaskInfo           ();
};

//==============================================================================
} // namespace tmipc
//==============================================================================
