﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//==============================================================================
// TaskType
//------------------------------------------------------------------------------
// This enumeration represents all the possible tasks that are supported by the
// agent. To maintain backwards compatibility, there are rules that must be
// observed:
//
//      1. TaskTypes can never be reassigned or renumbered.
//      2. TaskTypes can never be deleted, only added.
//      3. The integral value of TaskType must always be increasing in
//         sequential order starting at zero and without any gaps.
//      4. Tasks cannot be changed once they have shipped with an SDK release.
//         Only new tasks can be added.
//      5. If a task contains a bug that is to be fixed, implement a new task
//         which replicates the old task and implements the fix. The name of the
//         new task shall be named numerically to indicate its succession, e.g.
//              TaskType_HioFileRead2,
//              TaskType_HioFileRead3,
//              TaskType_HioFileRead4, and so on.
//
//==============================================================================

namespace tmipc {

enum TaskType
{
    TaskType_Invalid                        = 0,
    TaskType_HioFileOpen                    = 1,
    TaskType_HioFileGetSize                 = 2,
    TaskType_HioFileSetSize                 = 3,
    TaskType_HioFileGetSizeFromPath         = 4,
    TaskType_HioFileExists                  = 5,
    TaskType_HioFileRead                    = 6,
    TaskType_HioFileWrite                   = 7,
    TaskType_HioFileFlush                   = 8,
    TaskType_HioFileSetPriority             = 9,
    TaskType_HioFileGetPriority             = 10,
    TaskType_HioFileClose                   = 11,
    TaskType_HioFileCreate                  = 12,
    TaskType_HioFileDelete                  = 13,
    TaskType_HioFileRename                  = 14,
    TaskType_HioGetIoType                   = 15,
    TaskType_HioDirectoryExists             = 16,
    TaskType_HioDirectoryOpen               = 17,
    TaskType_HioDirectoryGetEntryCount      = 18,
    TaskType_HioDirectoryRead               = 19,
    TaskType_HioDirectoryClose              = 20,
    TaskType_HioDirectorySetPriority        = 21,
    TaskType_HioDirectoryGetPriority        = 22,
    TaskType_HioDirectoryCreate             = 23,
    TaskType_HioDirectoryDelete             = 24,
    TaskType_HioDirectoryRename             = 25,
    TaskType_HtcsSocket                     = 26,
    TaskType_HtcsClose                      = 27,
    TaskType_HtcsConnect                    = 28,
    TaskType_HtcsBind                       = 29,
    TaskType_HtcsListen                     = 30,
    TaskType_HtcsAccept                     = 31,
    TaskType_HtcsRecv                       = 32,
    TaskType_HtcsSend                       = 33,
    TaskType_HtcsShutdown                   = 34,
    TaskType_HtcsFcntl                      = 35,
    TaskType_HidControllerRead              = 36,
    TaskType_WaitForLaunchTask              = 37,
    TaskType_DebugTask                      = 38,
    TaskType_BenchmarkReport                = 39,
    TaskType_BenchmarkTask                  = 40,
    TaskType_EnvGetVar                      = 41,
    TaskType_LogTask                        = 42,
    TaskType_HioGetFileTimeStamp            = 43,
    TaskType_PowerManagementTask            = 44,
    TaskType_SettingsTask                   = 45,

    TaskType_TIOFileOpen                    = 46,
    TaskType_TIOFileClose                   = 47,
    TaskType_TIOFileRead                    = 48,
    TaskType_TIOFileWrite                   = 49,
    TaskType_TIOFileSetSize                 = 50,
    TaskType_TIOFileDelete                  = 51,
    TaskType_TIOFileMove                    = 52,
    TaskType_TIOFileGetInformation          = 53,
    TaskType_TIOFileSetAttributes           = 54,
    TaskType_TIOFileSetTime                 = 55,

    TaskType_TIODirectoryCreate             = 56,
    TaskType_TIODirectoryDelete             = 57,
    TaskType_TIODirectoryMove               = 58,
    TaskType_TIODirectoryGetInformation     = 59,

    TaskType_TIOSearchFetch                 = 60,
    TaskType_TIOGetFreeSpace                = 61,
    TaskType_TIOGetVolumeInformation        = 62,
    TaskType_DoNotUseSlot63                 = 63,
    TaskType_DoNotUseSlot64                 = 64,

    TaskType_MiniCoreDumpTask               = 65,
    TaskType_TMSInfoSupport                 = 66, // This is only used to denote whether or not state is saved during Sleep/Wake cycles.
    TaskType_ThreadFrozenTask               = 67,

    TaskType_CoredumpStartTask              = 68,

    TaskType_DiagnosticsTask                = 69,

    TaskType_PerformanceMonitorTask         = 70,

    TaskType_GetWorkingDirectoryPath        = 71,
    TaskType_GetWorkingDirectoryPathSize    = 72,

    //-------------------------------------------- << Put new service id's above this line and always preserve the order of existing service id's.  Do not introduce any gaps in the numbering sequence.
    TaskType_BackwardsCompatibilitySentinel = 73,
};

} // namespace tmipc



#include "tmipc_compatibility_enforcement.h"
