﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "tmipc_thread.h"
#include "tmipc_services_manager.h"

//==============================================================================
namespace tmipc {
//==============================================================================

class Packet;
class Service;

class Task
{
    friend class Service;
    friend class ServicesManager;
    friend class TaskList;

public:
    enum status
    {
        StatusPending,
        StatusComplete,
        StatusCanceled,
    };

public:
        Task*               m_pPrev;
        Task*               m_pNext;

protected:
        ServicesManager*    m_pServicesManager;
        s32                 m_Priority;
        u32                 m_ServiceId;
        u32                 m_TaskId;
        s32                 m_TaskType;
        Event               m_Event;
        bool                m_bNeedPackets;
        s32                 m_Status;
        bool                m_bExternallyOwned;
        // This flag is specific to Sleep/Wake.  Defaults to true.
        // - Lets TaskList know if it is allowed to put this task "to sleep".
        bool                m_bCanBePutToSleep;

virtual                    ~Task                ();


        void                SetCanBePutToSleep  ( bool bCanBePutToSleep );

public:
                            Task                ();

        void                SetServicesManager  ( ServicesManager* pServicesManager );
        ServicesManager*    GetServicesManager  ();
        s32                 GetStatus           () const;
        void                SetPriority         ( s32       Priority );
        s32                 GetPriority         () const;
        void                SetServiceId        ( u32       ServiceId );
        u32                 GetServiceId        () const;
        void                SetTaskId           ( u32       TaskId );
        u32                 GetTaskId           () const;
        void                SetTaskType         ( s32       TaskType );
        s32                 GetTaskType         () const;
        Service*            GetService          () const;
        void                SetExternallyOwned  ( bool      bState = true );
        bool                GetExternallyOwned  () const;
        bool                CanBePutToSleep     () const;

        tmipc::Result       WaitComplete        ( s32       Timeout );
        void                Complete            ();
        void                Cancel              ();

        void                SetNeedPackets      ( bool      bState = true );
        bool                GetNeedPackets      ();

        Packet*             AllocSendPacket     ( bool      bInitiate = false );

virtual void                OnRecvPacket        ( Packet*   pPacket ) = 0;
virtual void                OnInitiate          ( Packet*   pPacket ) = 0;
virtual void                OnSendPacket        ( Packet*   pPacket ) = 0;
virtual void                OnDumpDebugInfo     ();
};

//==============================================================================
} // namespace tmipc
//==============================================================================
