﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "tmipc_thread.h"
#include <unordered_map>

//==============================================================================
namespace tmipc {
//==============================================================================

class Packet;
class ServicesManager;
class Task;

class Service
{
protected:
        Service*            m_pNext;                // Next in list of services.
        ServicesManager*    m_pServicesManager;     // The node this service belongs to.
        const char*         m_pName;                // Service Name.
        u32                 m_ServiceId;            // Service Id.

public:
                            Service             ();
virtual                    ~Service             ();

        void                Create              ();
        void                Destroy             ();

        u32                 GetId               () const;
        Service*            GetNextService      () const;
        u32                 AllocTaskId         ();

protected:

virtual Task*               OnNewTask           ( Packet*           pPacket ) = 0;
virtual void                OnSleep             ();
virtual void                OnWakeUp            ();

protected:
        friend class ServicesManager;
        void                SetServicesManager  ( ServicesManager*  pServicesManager );
static  u32                 HashString          ( const char*       pString );
};

//==============================================================================
} // namespace tmipc
//==============================================================================
