﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "tmipc_service.h"
#include "tmipc_result.h"
#include "tmipc_services_manager.h"
#include "tmipc_packet.h"
#include "tmipc_task.h"
#include "..\DejaInsight.h"

//==============================================================================
namespace tmipc {
//==============================================================================

Service::Service()
:   m_pNext             ( NULL )
,   m_pServicesManager  ( NULL )
,   m_pName             ( "NULL" )
,   m_ServiceId         ( 0 )
{
}

//==============================================================================

Service::~Service()
{
}

//==============================================================================

void Service::Create()
{
}

//==============================================================================

void Service::Destroy()
{
}

//==============================================================================

u32 Service::GetId() const
{
    return( m_ServiceId );
}

//==============================================================================

Service* Service::GetNextService() const
{
    return( m_pNext );
}

//==============================================================================

u32 Service::AllocTaskId()
{
    return m_pServicesManager->AllocTaskId();
}

//==============================================================================

void Service::OnSleep()
{
TMA_POWER_TEST_PRINT( "[%s]!!! Service: 0x%08X.\n", _BestFunctionName_, GetId() );
}

//==============================================================================

void Service::OnWakeUp()
{
TMA_POWER_TEST_PRINT( "[%s]!!! Service: 0x%08X.\n", _BestFunctionName_, GetId() );
}

//==============================================================================

void Service::SetServicesManager( ServicesManager* pServicesManager )
{
    m_pServicesManager = pServicesManager;
}

//==============================================================================

u32 Service::HashString( const char* pString )
{
    u32 c      = (u32)(*pString++);
    u32 Hash   = c;
    u32 Length = 0;

    while( c )
    {
        Hash = (1000003 * Hash) ^ c;
        Length++;
        c = (u32)(*pString++);
    }
    Hash = Hash ^ Length;

    ASSERT( Hash != 0 );

    return Hash;
}

//==============================================================================
} // namespace tmipc
//==============================================================================
