﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "tmipc_task.h"
#include "tmipc_service.h"
#include "tmipc_packet.h"
#include "tmipc_result.h"

//==============================================================================
namespace tmipc {
//==============================================================================

struct result_record
{
    s32             m_Result;
    const char*     m_pString;
};

static result_record s_ResultTable[] =
{
    { TMIPC_RESULT_OK                     , "Success"                                             },
    { TMIPC_RESULT_NOT_IMPLEMENTED        , "Function not implemented somewhere in callstack."    },
    { TMIPC_RESULT_FAILED                 , "API failed."                                         },
    { TMIPC_RESULT_CONNECT_FAILED         , "Failed to connect to target."                        },
    { TMIPC_RESULT_CONNECT_NODE_IN_USE    , "Connect rejected, Node already in use, See Message." },
    { TMIPC_RESULT_CONNECT_VERSION_ERROR  , "Connect version error"                               },
    { TMIPC_RESULT_PACKET_OVERRUN         , "Read or write past end of packet."                   },
    { TMIPC_RESULT_USER_BUFFER_OVERRUN    , "Read or write past end of user buffer."              },
    { TMIPC_RESULT_DISCONNECTED           , "IPC target is disconnected."                         },
    { TMIPC_RESULT_DUPLICATE_SERVICE      , "Service is already registered."                      },
    { TMIPC_RESULT_UNKNOWN_SERVICE        , "Service is not known on this Node."                  },
    { TMIPC_RESULT_TIMEOUT                , "Operation timed out."                                },
    { TMIPC_RESULT_NOT_INITIALIZED        , "The Node has not been initialized."                  },
};

//==============================================================================

const char* ResultToString( Result result )
{
    // Not time critical, so linear search the table.
    s32 nTableEntries = sizeof( s_ResultTable ) / sizeof( s_ResultTable[0] );
    for( s32 i=0; i<nTableEntries; i++ )
    {
        result_record& r = s_ResultTable[i];
        if( r.m_Result == result )
        {
            return( r.m_pString );
        }
    }

    // Result not found.
    ASSERT( 0 );
    return( "Unknwown Error." );
}

//==============================================================================
} // namespace tmipc
//==============================================================================
