﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "tmipc_thread.h"
#include "tmipc_node.h"

//==============================================================================
namespace tmipc {
//==============================================================================

#if defined( TMIPC_TARGET_HORIZON ) && !defined( NN_DETAIL_TMA_NX_RELATED_HARDWARE )

class NodeTICS : public Node
{
public:
    virtual ~NodeTICS()
    {
    }

    virtual bool IsConnected()
    {
        return false;
    }

    virtual Result Disconnect()
    {
        return TMIPC_RESULT_FAILED;
    }

    virtual Result Send( Packet* pPacket )
    {
        (void)pPacket;
        return TMIPC_RESULT_FAILED;
    }

    static Result Initialize()
    {
        return TMIPC_RESULT_FAILED;
    }

    static Result Finalize()
    {
        return TMIPC_RESULT_FAILED;
    }
};

#else

class NodeTICS : public Node
{
private:

static  Thread      m_ListenThread;         // Threads for listen, send and
static  Thread      m_SendThread;           // receive.
static  Thread      m_ReceiveThread;        //
        MsgQueue    m_SendQueue;            // The send queue (Packets).
        MsgQueue    m_ReceiveQueue;         // The receive queue (Packets).
        Event       m_ListenEvent;          // Waits for a disconnection or Disconnect() call.

static  void*       m_pListenThreadStack;   // The thread stacks for listen,
static  void*       m_pSendThreadStack;     // send and receive.
static  void*       m_pReceiveThreadStack;  //

        bool        m_bIsListening;         // true: the Node is actively listening for connections.
        bool        m_bStopListening;       // true: stops listening for connections.
        bool        m_bIsConnected;         // Is there a TICS connection? TargetManager might not be connected.

private:
        // Listen thread.
static  s32     ListenThread( void* lpThis );

        // Send thread.
static  s32     SendThread( void* lpThis );

        // Receive thread.
static  s32     ReceiveThread( void* lpThis );

        // Starts the Send/Receive threads.
        void    StartThreads();

        // Stops the Send/Receive threads.
        void    StopThreads();

public:

        // Constructor/destructor.
        NodeTICS();
        virtual ~NodeTICS();

        // Initialize the TICS interface.
static  void    Initialize();

        // Finalize NodeTICS.
static  void    Finalize();

        // Listens for connections.
virtual Result  Listen();

        // Stops listening for connections.  This does *not* cause a disconnect.
virtual void    StopListening();

        // Disconnect from TICS.
virtual Result  Disconnect();

        // Is the Node listening for connections?
        bool    IsListening() const;
        // Is the Target connected a host app (Win32 - TargetManager, etc.)?
virtual bool    IsConnected();
        // Send data to the host app (Win32 - TargetManager, etc.).
virtual Result  Send(Packet* pPacket);
};

#endif

//==============================================================================
} // namespace tmipc
//==============================================================================
