﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "tmipc_defines.h"
#include "tmipc_node.h"
#include "tmipc_result.h"

//==============================================================================
namespace tmipc {
//==============================================================================

#if defined( TMIPC_TARGET_WIN )
class NodeAddressTCP
{
        nn::socket::SockAddrIn  m_SockAddr;

public:
                            NodeAddressTCP      ();
                            NodeAddressTCP      ( const char*           pIP,
                                                  s32                   Port );
virtual                    ~NodeAddressTCP      ();

        void                Set                 ( const char*           pIP,
                                                  s32                   Port );
const   nn::socket::SockAddrIn& SockAddr        () const;
};
#endif

//==============================================================================

class NodeTCP : public Node
{
protected:
#if defined( TMIPC_TARGET_WIN )
        //NodeAddressTCP      m_LocalAddress;
        NodeAddressTCP      m_RemoteAddress;
#endif
        MsgQueue            m_SendQ;

        int                 m_ConnSocket;
        Result              m_ConnResult;

        Thread              m_ListenThread;
        Thread              m_SendThread;
        Thread              m_RecvThread;

        s32                 m_ListenPort;
        int                 m_ListenSocket;
        int                 m_ConnectedSocket;

        void*               m_pSendThreadStack;
        void*               m_pRecvThreadStack;
        void*               m_pListenThreadStack;
        size_t              m_SendThreadStackSize;
        size_t              m_RecvThreadStackSize;
        size_t              m_ListenThreadStackSize;

public:
                            NodeTCP         ();
virtual                    ~NodeTCP         ();

        // Listens for connections.
virtual Result              Listen          ();
virtual void                StopListening   ();
        s32                 GetListenPort   ();
#if defined( TMIPC_TARGET_WIN )
        s32                 Connect         ( NodeAddressTCP&   TargetAddress );
#endif

virtual Result              Disconnect      ();
virtual bool                IsConnected     ();

virtual Result              Send            ( Packet*           pPacket );

protected:
#if defined( TMIPC_TARGET_WIN )
static  s32                 ConnectThread   ( void*             pArg );
#endif
static  s32                 ListenThread    ( void*             pArg );
static  s32                 SendThread      ( void*             pArg );
static  s32                 RecvThread      ( void*             pArg );
};

//==============================================================================
} // namespace tmipc
//==============================================================================
