﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "..\tmagent.h"

//==============================================================================
namespace tma {
//==============================================================================

class Mutex
{
    nn::os::MutexType           m_Mutex;

public:
explicit                Mutex       ( );

            void        Create      ();
            void        Destroy     ();
            void        Lock        ();
            void        Unlock      ();
};

//==============================================================================

class ScopedLock
{
    Mutex& m_Mutex;
public:
explicit    ScopedLock  ( Mutex& Mutex ) : m_Mutex( Mutex )
            {
                Mutex.Lock();
            }
           ~ScopedLock  ()
            {
                m_Mutex.Unlock();
            }
};

//==============================================================================
} // namespace tma
//==============================================================================
