﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "..\tmagent.h"

#include <nn/os.h>
using nn::os::MutexType;
using nn::os::MessageQueueType;

//==============================================================================
namespace tma {
//==============================================================================

class MQ
{
public:
    typedef void* Msg;

protected:
            bool                m_Created;      // true when the mq is created.
            MessageQueueType    m_q;            // OS message queue.

            Msg*                m_pQueue;       // Pointer to storage for the queue.
            bool                m_Allocated;    // true if Queue is in allocated storage and should be deleted.
            s32                 m_Capacity;     // Capacity of the queue (same as semaphore max count).
volatile    s32                 m_Count;        // Number of items currently in queue.
volatile    s32                 m_iRead;        // Index to read from.
volatile    s32                 m_iWrite;       // Index to write to.

public:
                            MQ          ();                         // Constructor.
                           ~MQ          ();                         // Destructor.

            void            Create      ( s32       Capacity );     // Create the message queue.

            void            Create      ( s32       Capacity,
                                          Msg*      pStorage );     // Create the message queue with the provided storage.

            void            Destroy     ();                         // Destroy the message queue.

            bool            IsValid     ();                         // Is the message queue valid for use.

            bool            Send        ( void*     pMessage,
                                          bool      Block=true );   // Send a message to the queue, can block or return success code.
            bool            Receive     ( void**    ppMessage,
                                          bool      Block=true );   // Recieve a message from the queue.
            void*           Receive     ();                         // Receive a message from the queue, always blocks until success.

            s32             GetCount    ();                         // Get the count of messages in the queue.
};

//==============================================================================
} // namespace tma
//==============================================================================
