﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "..\tmipc\tmipc_packet.h"
#include "..\tmipc\tmipc_task.h"
#include "..\tm_result.h"
#include <nn/fs.h>

//==============================================================================
namespace tma { namespace target_io {
//==============================================================================

#define PROFILE_TIO_TASKS TMA_MACRO_VALUE(0)

class TIOTask : public tmipc::Task
{
public:
    explicit        TIOTask ();
                   ~TIOTask ();

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );
virtual void        OnRecvPacket        ( tmipc::Packet*    pPacket );
virtual void        OnSendPacket        ( tmipc::Packet*    pPacket );

    void            OnComplete          ( tmapi::result     Result );

protected:

static tmapi::result    ConvertToTMAPI  ( nn::Result        Res );

#if PROFILE_TIO_TASKS
    int64_t         m_StartingTick;
#endif
};

//==============================================================================

class TIOTaskGetFreeSpace : public TIOTask
{
public:

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );

};

//==============================================================================

class TIOTaskGetVolumeInformation : public TIOTask
{
public:

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );

};

//==============================================================================
// File tasks
//==============================================================================

class TIOTaskFileRead : public TIOTask
{
public:

    explicit        TIOTaskFileRead ();
                   ~TIOTaskFileRead ();

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );
virtual void        OnSendPacket        ( tmipc::Packet*    pPacket );

protected:
    tmapi::result   HandlePacket        ( tmipc::Packet*    pPacket );
    void            Finish              ( tmapi::result     Result );

    nn::fs::FileHandle m_FileHandle;
    int64_t         m_AmountToRead;
    int64_t         m_ReadOffset;
    int32_t         m_AmountRead;
};

//==============================================================================

class TIOTaskFileWrite  : public TIOTask
{
public:

    explicit        TIOTaskFileWrite();
                   ~TIOTaskFileWrite();

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );
virtual void        OnRecvPacket        ( tmipc::Packet*    pPacket );

protected:
    tmapi::result   HandlePacket        ( tmipc::Packet*    pPacket );

    nn::fs::FileHandle m_FileHandle;
    int64_t         m_AmountToWrite;
    int32_t         m_AmountWritten;
    int64_t         m_WriteOffset;

#if PROFILE_TIO_TASKS
    int64_t         m_WorkingTicks;
#endif
};

//==============================================================================

class TIOTaskFileSetSize : public TIOTask
{
public:

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );

};

//==============================================================================

class TIOTaskFileDelete : public TIOTask
{
public:

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );

};

//==============================================================================

class TIOTaskFileMove : public TIOTask
{
public:

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );

};

//==============================================================================

class TIOTaskFileGetInformation : public TIOTask
{
public:

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );

};

//==============================================================================

class TIOTaskFileSetAttributes : public TIOTask
{
public:

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );

};

//==============================================================================

class TIOTaskFileSetTime : public TIOTask
{
public:

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );

};

//==============================================================================
// Directory tasks
//==============================================================================

class TIOTaskDirectoryCreate : public TIOTask
{
public:

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );

};

//==============================================================================

class TIOTaskDirectoryDelete : public TIOTask
{
public:

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );

};

//==============================================================================

class TIOTaskDirectoryMove : public TIOTask
{
public:

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );

};

//==============================================================================

class TIOTaskDirectoryGetInformation : public TIOTask
{
public:

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );

};

//==============================================================================
// Search task
//==============================================================================

class TIOTaskSearchFetch : public TIOTask
{
public:

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );
virtual void        OnSendPacket        ( tmipc::Packet*    pPacket );

protected:
    bool            HandleReplyPacket   ( tmipc::Packet* pPacket );
    nn::fs::DirectoryHandle m_DirHandle;
};

//==============================================================================
}}
//==============================================================================
