﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "power_management_service.h"
#include "power_management_task.h"
#include <nn/nn_SdkLog.h>

//==============================================================================
namespace tma { namespace powermanagement {
//==============================================================================

Service::Service()
{
//NN_SDK_LOG( "[powermanagement::Service::Service( %p )]\n", this );
    m_ServiceId = HashString( "PowerManagementService" );
TMA_POWER_TEST_PRINT( "[%s]!!! - A.\n", _BestFunctionName_ );
}

//==============================================================================

Service::~Service()
{
//NN_SDK_LOG( "[powermanagement::Service::~Service( %p )]\n", this );
}

//==============================================================================

tmipc::Task* Service::OnNewTask( tmipc::Packet* pPacket )
{
//NN_SDK_LOG( "[powermanagement::Service::OnNewTask( %p )]\n", this );
TMA_POWER_TEST_PRINT( "[%s]!!! - A.\n", _BestFunctionName_ );
    (void)pPacket;
    ASSERT( 0 );
    return( nullptr );
}

//==============================================================================

void Service::Init()
{
//NN_SDK_LOG( "[powermanagement::Service::Init( %p )]\n", this );
TMA_POWER_TEST_PRINT( "[%s]!!! - A.\n", _BestFunctionName_ );
    Create();
}

//==============================================================================

void Service::Kill()
{
//NN_SDK_LOG( "[powermanagement::Service::Kill( %p )]\n", this );
TMA_POWER_TEST_PRINT( "[%s]!!! - A.\n", _BestFunctionName_ );
    Destroy();
}

//==============================================================================

tmipc::Result Service::NotifyTMSGoingToSleep()
{
    tmipc::Result Result = tmipc::Result::TMIPC_RESULT_OK;
//NN_SDK_LOG( "[powermanagement::Service::NotifyTMSGoingToSleep( 0x%p )] - Packet: 0x%p\n", this );
TMA_POWER_TEST_PRINT( "[%s]!!! - Start.\n", _BestFunctionName_ );

    // Allocate the Task buffer.
    void* pMem = nullptr;
    if( Result == tmipc::Result::TMIPC_RESULT_OK )
    {
        pMem = s_Allocate( sizeof( Task ) );
        if( pMem == nullptr )
        {
            Result = tmipc::Result::TMIPC_RESULT_FAILED;
            NN_SDK_LOG("Failed to allocate powermanagement::Task buffer.");
        }
    }

    // Allocate the Task.
    Task* pTask = nullptr;
    if( Result == tmipc::Result::TMIPC_RESULT_OK )
    {
        pTask = new (pMem) Task;
        if( pTask != nullptr )
        {
            // This needs to be set before calling pTask->AllocSendPacket(...)
            // or it will cause that function to ASSERT.
            pTask->SetServicesManager( m_pServicesManager );
            pTask->SetServiceId( m_ServiceId );
            pTask->SetTaskId( m_pServicesManager->AllocTaskId() );
        }
        else
        {
            Result = tmipc::Result::TMIPC_RESULT_FAILED;
            NN_SDK_LOG("Failed to construct the powermanagement::Task instance.");
        }
    }

    // Allocate a Send Packet.
    tmipc::Packet* pPacket = { nullptr };
    if( Result == tmipc::Result::TMIPC_RESULT_OK )
    {
        pPacket = pTask->AllocSendPacket( true );
        if( pPacket == nullptr )
        {
            Result = tmipc::Result::TMIPC_RESULT_FAILED;
            NN_SDK_LOG("Failed to allocate a SendPacket.");
        }
    }

    // Set up the Task data.
    if( Result == tmipc::Result::TMIPC_RESULT_OK )
    {

TMA_POWER_TEST_PRINT( "[%s]!!! - A.\n", _BestFunctionName_ );
        Result = m_pServicesManager->SubmitTask( pTask, pPacket );
TMA_POWER_TEST_PRINT( "[%s]!!! - B.  SubmitTask(0x%08x, %d) Result: %d.\n", _BestFunctionName_, m_ServiceId, pPacket->GetTaskId(), Result );
    }

    // Wait for the task to finish.
    if( Result == tmipc::Result::TMIPC_RESULT_OK )
    {
TMA_POWER_TEST_PRINT( "[%s]!!! - C.\n", _BestFunctionName_ );
        Result = pTask->WaitComplete( TMIPC_INFINITE );
TMA_POWER_TEST_PRINT( "[%s]!!! - D.  SubmitTask Result: %d.\n", _BestFunctionName_, Result );
    }

    // Done with the task.
    if( pTask != nullptr )
    {
TMA_POWER_TEST_PRINT( "[%s]!!! - E.\n", _BestFunctionName_ );
        pTask->~Task();
        s_Deallocate(pTask, sizeof(Task));
    }

TMA_POWER_TEST_PRINT( "[%s]!!! - Finish.\n", _BestFunctionName_ );

    return Result;
}

//==============================================================================
}} // namespace
//==============================================================================
