﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <stdint.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_File.h>
#include <nn/fs/fs_FileSystem.h>
#include <nn/fs/fs_Directory.h>

//==============================================================================

namespace nn { namespace tma {

//==============================================================================

namespace file_io {

        typedef uint64_t                    TMA_FILE_HANDLE;

        nn::Result      OpenFile            ( TMA_FILE_HANDLE*              pHandle,
                                              const char*                   pPath,
                                              uint32_t                      openMode );

        //nn::fs0 signature
        nn::Result      ReadFile            ( int32_t*                      pOut,
                                              const TMA_FILE_HANDLE         handle,
                                              int64_t                       offset,
                                              void*                         pBuffer,
                                              int64_t                       size );

        //nn::fs signature
        nn::Result      ReadFile            ( size_t*                       pOut,
                                              const TMA_FILE_HANDLE         handle,
                                              int64_t                       offset,
                                              void*                         pBuffer,
                                              size_t                        size,
                                              const nn::fs::ReadOption&     option );

        //nn::fs0 signature
        nn::Result      WriteFile           ( int32_t*                      pOut,
                                              const TMA_FILE_HANDLE         handle,
                                              int64_t                       offset,
                                              const void*                   pBuffer,
                                              int64_t                       size,
                                              bool                          flush );

        //nn::fs signature
        nn::Result      WriteFile           ( const TMA_FILE_HANDLE         handle,
                                              int64_t                       offset,
                                              const void*                   pBuffer,
                                              int64_t                       size,
                                              const nn::fs::WriteOption&    option);

        nn::Result      GetFileSize         ( int64_t*                      pOut,
                                              const TMA_FILE_HANDLE         handle );

        nn::Result      SetFileSize         ( const TMA_FILE_HANDLE         handle,
                                              int64_t                       size );

        nn::Result      GetFileTimeStamp    ( uint64_t*                     pCreateTime,
                                              uint64_t*                     pAccessTime,
                                              uint64_t*                     pModifyTime,
                                              const char*                   pPath );

        nn::Result      FlushFile           ( const TMA_FILE_HANDLE         handle );

        nn::Result      SetPriorityForFile  ( const TMA_FILE_HANDLE         handle,
                                              int32_t                       priority );

        nn::Result      GetPriorityForFile  ( int32_t*                      pOut,
                                              const TMA_FILE_HANDLE         handle );

        void            CloseFile           ( const TMA_FILE_HANDLE         handle );

        nn::Result      FileExists          ( bool*                         pExists,
                                              const char*                   pPath );

        nn::Result      CreateFile          ( const char*                   pPath,
                                              int64_t                       size );

        nn::Result      DeleteFile          ( const char*                   pPath );

        nn::Result      RenameFile          ( const char*                   pFromName,
                                              const char*                   pToName );

        nn::Result      GetIOType           ( nn::fs::DirectoryEntryType*   pType,
                                              const char*                   pPath );

} // namespace file_io

//==============================================================================

namespace directory_io
{

        typedef uint64_t                    TMA_DIR_HANDLE;

        nn::Result  OpenDirectory           ( TMA_DIR_HANDLE*           pHandle,
                                              const char*               pathName,
                                              fs::OpenDirectoryMode     OpenMode = fs::OpenDirectoryMode_File );

        nn::Result  GetEntryCount           ( int64_t*                  pCount,
                                              const TMA_DIR_HANDLE&     handle );

        nn::Result  ReadDirectory           ( int64_t*                  pOut,
                                              nn::fs::DirectoryEntry    pEntries[],
                                              const TMA_DIR_HANDLE&     handle,
                                              int64_t                   numEntries );

        nn::Result  SetPriorityForDirectory ( const TMA_DIR_HANDLE      handle,
                                              int32_t                   priority );

        nn::Result  GetPriorityForDirectory ( int32_t*                  pOut,
                                              const TMA_DIR_HANDLE      handle );

        void        CloseDirectory          ( const TMA_DIR_HANDLE      handle );

        nn::Result  DirectoryExists         ( bool*                     pExists,
                                              const char*               pathName );

        nn::Result  CreateDirectory         ( const char*               pathName );
        nn::Result  DeleteDirectory         ( const char*               pathName,
                                              bool                      recursively );

        nn::Result  RenameDirectory         ( const char*               fromName,
                                              const char*               ToName );

} // namespace directory_io

//==============================================================================

}} // namespace
//==============================================================================
