﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../tmagent.h"
#include "../tmipc/tmipc_result.h"
#include "get_working_directory_path_size_task.h"

//==============================================================================
namespace tma { namespace generic_service {
//==============================================================================

GetWorkingDirectoryPathSizeTask::GetWorkingDirectoryPathSizeTask()
:   m_pLength( nullptr )
,   m_Result( Result::CONNECTION_FAILURE )
{
    m_TaskType = tmipc::TaskType_GetWorkingDirectoryPathSize;
}

//==============================================================================

GetWorkingDirectoryPathSizeTask::~GetWorkingDirectoryPathSizeTask()
{
}

//==============================================================================

void GetWorkingDirectoryPathSizeTask::OnInitiate( tmipc::Packet* pPacket )
{
    (void)pPacket;
    ASSERT( 0 );
}

//==============================================================================

void GetWorkingDirectoryPathSizeTask::OnRecvPacket( tmipc::Packet* pPacket )
{
    m_Result = Result::CONNECTION_FAILURE;

    s32 Result = pPacket->ReadS32( *m_pLength );
    if( Result == tmipc::TMIPC_RESULT_OK )
    {
        // All good.
        m_Result = Result::SUCCESS;
    }

    // Done.
    Complete();

// Debug only.
//    NN_SDK_LOG( "[tma]!!! GetWorkingDirectoryPathSizeTask::OnRecvPacket: Length: %d. Result: %d. m_Result: %d.\n", *m_pLength, Result, m_Result );
}

//==============================================================================

void GetWorkingDirectoryPathSizeTask::OnSendPacket( tmipc::Packet* pPacket )
{
    // TODO - Handle Packet
    (void)pPacket;
}

//==============================================================================
}} // namespace
//==============================================================================
