﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "..\tmagent.h"
#include "..\tmipc\tmipc_result.h"
#include "env_opcodes.h"
#include "env_Service.h"
#include "env_Task.h"

//==============================================================================
namespace tma { namespace env {
//==============================================================================

EnvGetVarTask::EnvGetVarTask()
:   m_pLength( NULL )
,   m_pBuffer( NULL )
,   m_Success( TMA_ENV_RESULT_BAD_PACKET )
{
    m_TaskType = tmipc::TaskType_EnvGetVar;
}

//==============================================================================

EnvGetVarTask::~EnvGetVarTask()
{
}

//==============================================================================

void EnvGetVarTask::OnInitiate( tmipc::Packet* pPacket )
{
    (void)pPacket;
    ASSERT( 0 );
}

//==============================================================================

void EnvGetVarTask::OnRecvPacket( tmipc::Packet* pPacket )
{
    //(void)pPacket;
    m_Success = TMA_ENV_RESULT_BAD_PACKET;
    pPacket->ReadS32( m_Success );

//  NN_SDK_LOG( "EnvTask::OnRecvPacket %d\n", m_Success );

    if( m_Success )
    {
        s32 bufferLen = m_BufferLength;
        s32 stringLen = 0;
        s32 result = pPacket->ReadString( m_pBuffer, bufferLen, &stringLen );
        if( result != tmipc::TMIPC_RESULT_OK )
        {
            if( result == tmipc::TMIPC_RESULT_USER_BUFFER_OVERRUN )
                m_Success = TMA_ENV_RESULT_BUFFER_TOO_SMALL;  // Buffer overflow
            else if( result == tmipc::TMIPC_RESULT_PACKET_OVERRUN )
                m_Success = TMA_ENV_RESULT_PACKET_TOO_SMALL;  // Packet overflow
        }
        if( bufferLen > 0 )
            m_pBuffer[bufferLen - 1] = 0;
        *m_pLength = stringLen;

//      NN_SDK_LOG( "EnvTask::OnRecvPacket '%s' %d\n", m_pBuffer, *m_pLength );

        if( m_Success == 1 )
            m_Success = TMA_ENV_RESULT_SUCCESS;
        else if( m_Success == 0 )
            m_Success = TMA_ENV_RESULT_NOT_FOUND;
    }
    else
    {
        *m_pLength = 0;
        m_Success = TMA_ENV_RESULT_NOT_FOUND;
    }
    // Done.
    Complete();
}

//==============================================================================

void EnvGetVarTask::OnSendPacket( tmipc::Packet* pPacket )
{
    // TODO - Handle Packet
    (void)pPacket;
}

//==============================================================================
}} // namespace
//==============================================================================
