﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//==============================================================================
//  INCLUDES
//==============================================================================

#include "..\tmagent.h"
#include "env_Service.h"
#include "env_opcodes.h"

//==============================================================================
namespace tma { namespace env {
//==============================================================================

AgentEnvService::AgentEnvService()
{
    DEJA_TRACE( "AgentEnvService::AgentEnvService", "AgentEnvService" );
    m_ServiceId = HashString( "EnvService" );
}

//==============================================================================

AgentEnvService::~AgentEnvService()
{
    DEJA_TRACE( "AgentEnvService::~AgentEnvService", "~AgentEnvService" );
}

//==============================================================================

void AgentEnvService::Init()
{
    DEJA_TRACE( "AgentEnvService::Init", "Init" );
    Create();
}

//==============================================================================

void AgentEnvService::Kill()
{
    DEJA_TRACE( "AgentEnvService::Kill", "Kill" );
    Destroy();
}

//==============================================================================

tmipc::Task* AgentEnvService::OnNewTask( tmipc::Packet* pPacket )
{
    (void)pPacket;
    ASSERT( 0 );
    return( NULL );
}

//==============================================================================

s32 AgentEnvService::GetEnvironmentVariable( int32_t* pLength, char* pBuffer, int32_t bufferLength, const char* pName ) NN_NOEXCEPT
{
    s32 Result = TMA_ENV_RESULT_BUFFER_TOO_SMALL;
    {
        void* pMem = s_Allocate( sizeof( EnvGetVarTask ) );
        EnvGetVarTask* pTask = new (pMem)EnvGetVarTask;
        pTask->SetServicesManager( m_pServicesManager );
        pTask->SetServiceId( m_ServiceId );
        pTask->SetTaskId( m_pServicesManager->AllocTaskId() );

        tmipc::Packet* pPacket = pTask->AllocSendPacket( true );
        pPacket->WriteString( pName );
        pTask->m_pLength = pLength;
        pTask->m_pBuffer = pBuffer;
        pTask->m_BufferLength = bufferLength;

        m_pServicesManager->SubmitTask( pTask, pPacket );
        pTask->WaitComplete( TMIPC_INFINITE );
        // Successfully read the variable?
        Result = pTask->m_Success;
        // Done with the task.
        pTask->~EnvGetVarTask();
        s_Deallocate( pTask, sizeof( EnvGetVarTask ) );
    }

    return( Result );
}

//==============================================================================

s32 AgentEnvService::GetEnvironmentVariableLength( int32_t* pLength, const char* pName ) NN_NOEXCEPT
{
    s32 Result = TMA_ENV_RESULT_BAD_PACKET;
    {
        void* pMem = s_Allocate( sizeof( EnvGetVarTask ) );
        EnvGetVarTask* pTask = new (pMem) EnvGetVarTask();
        pTask->SetServicesManager( m_pServicesManager );
        pTask->SetServiceId( m_ServiceId );
        pTask->SetTaskId( m_pServicesManager->AllocTaskId() );

        tmipc::Packet* pPacket = pTask->AllocSendPacket( true );
        pPacket->WriteString( pName );
        pTask->m_pLength = pLength;
        pTask->m_pBuffer = nullptr;
        pTask->m_BufferLength = 0;

        m_pServicesManager->SubmitTask( pTask, pPacket );
        pTask->WaitComplete( TMIPC_INFINITE );
        // Successfully read the variable?
        Result = pTask->m_Success;
        if( Result == TMA_ENV_RESULT_BUFFER_TOO_SMALL )
        {
            Result = TMA_ENV_RESULT_SUCCESS;
        }
        // Done with the task.
        pTask->~EnvGetVarTask();
        s_Deallocate( pTask, sizeof( EnvGetVarTask ) );
    }

    return Result;
}

//==============================================================================
}} // namespace
//==============================================================================
