﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "..\tmipc\tmipc_packet.h"
#include "..\tmipc\tmipc_task.h"
#include "dbg_Message.h"
#include "..\tma\tma_Thread.h"
#include "..\tma\tma_MQ.h"

//==============================================================================
namespace tma { namespace dbg {
//==============================================================================

typedef u64 process_id;

class SimDebugTask : public tmipc::Task
{
public:
    static void     Initialize            ();
    static void     Finalize              ();

                    SimDebugTask            ();
                   ~SimDebugTask            ();

    void            OnInitiate           ( tmipc::Packet*       pPacket );
    void            OnRecvPacket         ( tmipc::Packet*       pPacket );
    void            OnSendPacket         ( tmipc::Packet*       pPacket );

    void            Start                 ( TMAgent_message_type MessageType,
                                           process_id            ProcessId,
                                           void*                 pData,
                                           s32                   SizeOfData);
protected:
    void            HandleStandardCommand( u32                  CommandCode,
                                           u64                  ProcessId,
                                           u64                  ParameterVal );
    void            HandleLoadElfCommand ( tmipc::Packet*       pPacket );
    void            HandleSetBkptCommand ( u64                  ProcessId,
                                           tmipc::Packet*       pPacket );
    void            HandleStepCommand    ( u64                  ProcessId,
                                           tmipc::Packet*       pPacket );
    void            HandleReadMemCommand ( u64                  ProcessId,
                                           tmipc::Packet*       pPacket );
    void            HandleReadRegDefsCommand( u64               ProcessId,
                                           tmipc::Packet*       pPacket );
    void            HandleReadRegDataCommand( u64               ProcessId,
                                           tmipc::Packet*       pPacket );
    void            HandleWriteMemCommand( u64                  ProcessId,
                                           tmipc::Packet*       pPacket );
    void            HandleWriteRegCommand( u64                  ProcessId,
                                           tmipc::Packet*       pPacket );

    void            HandleWriteDumpCommand( u64                  ProcessId,
                                            tmipc::Packet*       pPacket );
    void            HandleGetNumProcesses ( tmipc::Packet*       pPacket );

    void            Packetize            ( TMAgent_message_type MessageType,
                                           u64                  ProcessId,
                                           s32                  ResultCode,
                                           void*                Data,
                                           s32                  DataSize );

    static void*    LoadExecutableThread( void* pArgs );

private:
    // The name of "this" running application.
    static char     m_ApplicationFileName[1024];
};

//==============================================================================
}}
//==============================================================================
