﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "..\tmagent.h"

enum
{
    MAX_PATH = 260 // Windows API Path Length Limit
};

//==============================================================================
namespace tma { namespace dbg {
//==============================================================================

#if !defined( NN_TMA_SIM_INSTANCE )

class ModuleDefinition
{
public:
    ModuleDefinition( const char* pName, u64 Address, u64 Size );
    explicit ModuleDefinition( nn::dbg::ModuleInfo* pDefined );
    ModuleDefinition();
    ~ModuleDefinition();

    // Operators
    bool operator !=  (const ModuleDefinition& Definition) const;
    ModuleDefinition&  operator = (const ModuleDefinition& List);

    //Fetch info
    char* GetName()
    {
        return m_Name;
    }

    bool IsValid()
    {
        return strlen( m_Name ) > 0;
    }

    void SetName( char* pName )
    {
        strncpy( m_Name, pName, sizeof(m_Name) - 1 );
        m_Name[sizeof(m_Name) - 1]  = 0;
    }


    u64 GetAddress() { return m_Address; }
    u64 GetSize() { return m_Size; }
    char* GetID() { return m_ID; }

    enum
    {
        MODULE_ID_SIZE = 32
    };

protected:
    char m_Name[MAX_PATH];
    char m_ID[MODULE_ID_SIZE];
    u64 m_Address;
    u64 m_Size;
};

//==============================================================================
// Module list

class ModuleList
{
public:
    ModuleList();
    ~ModuleList();

    void Clear();
    void Populate( char* pProcessName, nn::svc::Handle Handle, u64 ProcessId );
    s32  GetCount()
    {
        return m_NumberOfModules;
    }
    bool GetModuleAtIndex( s32 Index, void* Buffer );

    // Operators
    bool operator !=  (const ModuleList& List) const;
    ModuleList&  operator = (const ModuleList& List);

protected:
    s32 m_NumberOfModules;
    ModuleDefinition* m_pModules;
};

//==============================================================================

class Modules
{
public:
    Modules();
    ~Modules();

    void        Init( char* pProcessName, nn::svc::Handle Handle, u64 ProcessId );
    void        Kill();
    void        Attach( nn::svc::Handle Handle );
    s32         GetModuleAtIndex( s32 Index, void* Module );
    s32         GetCount();

    //This returns TRUE if the module list changed, false if not.
    bool        Update();

private:
    bool            m_NeedsUpdate;
    nn::svc::Handle m_ProcessHandle;
    u64             m_ProcessId;
    char*           m_pProcessName;
    ModuleList      m_Modules;
};

#endif // NN_TMA_SIM_INSTANCE

//==============================================================================
}} // namespace
//==============================================================================
