﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;

namespace nn
{
    [CppRefPath(@"<nn/nn_TimeSpan.h>")]
    [ExternalStruct(8, 8)]
    public struct TimeSpanType
    {
    }

    namespace time
    {
        [CppRefPath(@"<nn/time/time_Types.h>")]
        [ExternalStruct(24, 8)]
        public struct SteadyClockTimePoint
        {
        }

        [CppRefPath(@"<nn/time/time_Types.h>")]
        [ExternalStruct(8, 8)]
        public struct PosixTime
        {
        }

        [CppRefPath(@"<nn/time/time_Types.h>")]
        [ExternalStruct(32, 8)]
        public struct SystemClockContext
        {
        }

        [CppRefPath(@"<nn/time/time_LocationName.h>")]
        [ExternalStruct(36, 1)]
        public struct LocationName
        {
        }

        [CppRefPath(@"<nn/time/time_TimeZone.h>")]
        [ExternalStruct(16, 4)]
        public struct TimeZone
        {
        }

        [CppRefPath(@"<nn/time/time_CalendarTime.h>")]
        [ExternalStruct(8, 2)]
        public struct CalendarTime
        {
        }

        [CppRefPath(@"<nn/time/time_TimeZoneRule.h>")]
        [ExternalStruct(16384, 8)]
        [LargeData(true)]
        public struct TimeZoneRule
        {
        }

        [CppRefPath(@"<nn/time/time_TimeZoneRuleVersion.h>")]
        [ExternalStruct(16, 1)]
        public struct TimeZoneRuleVersion
        {
        }


        namespace sf
        {
            // enum を排除した型
            [CppRefPath(@"<nn/timesrv/detail/service/timesrv_ITimeZoneService.sfdl.h>")]
            public struct CalendarAdditionalInfo
            {
                public int8_t dayOfWeek;
                public int32_t yearDay;
                public nn.time.TimeZone timeZone;
            }

            [CppRefPath(@"<nn/timesrv/detail/service/timesrv_IStaticService.sfdl.h>")]
            [LargeData(true)]
            public struct ClockSnapshot
            {
                public nn.time.SystemClockContext userSystemClockContext;
                public nn.time.SystemClockContext netSystemClockContext;
                public nn.time.PosixTime userSystemClockPosixTime;
                public nn.time.PosixTime netSystemClockPosixTime;
                public nn.time.CalendarTime userCalendarTime;
                public nn.time.CalendarTime netCalendarTime;
                public nn.time.sf.CalendarAdditionalInfo userCalendarAdditionalInfo; // enum排除版
                public nn.time.sf.CalendarAdditionalInfo netCalendarAdditionalInfo; // enum排除版
                public nn.time.SteadyClockTimePoint steadyClockTimePoint;
                public nn.time.LocationName locationName;
                public bool isAutomaticCorrectionEnabled;
                public uint8_t initialType;
                public uint8_t version;
                [FixedArray(1)]
                public uint8_t[] padding;
            }
        }
    }
}
