﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn
{
    namespace timesrv.detail.service
    {
        [CppRefPath("<nn/timesrv/detail/service/timesrv_ITimeZoneService.sfdl.h>")]
        public interface ITimeZoneService : IServiceObject
        {
            [MethodId(0)]
            Result GetDeviceLocationName(Out<nn.time.LocationName> outValue);

            [MethodId(1)]
            Result SetDeviceLocationName(nn.time.LocationName value);

            [MethodId(2)]
            Result GetTotalLocationNameCount(Out<int32_t> outValue);

            [MethodId(3)]
            Result LoadLocationNameList(
                Out<int32_t> outCount,
                [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<nn.time.LocationName> pOutLocationNameList,
                int32_t offset);

            [MethodId(4)]
            Result LoadTimeZoneRule(
                [BufferTransferMode(BufferTransferMode.MapAlias)] Out<nn.time.TimeZoneRule> outValue,
                nn.time.LocationName locationName);

            [MethodId(5)]
            Result GetTimeZoneRuleVersion(Out<nn.time.TimeZoneRuleVersion> outValue);

            [MethodId(6)]
            Result GetDeviceLocationNameAndUpdatedTime(
                Out<nn.time.LocationName> outLocationName,
                Out<nn.time.SteadyClockTimePoint> outUpdatedTime);

            // ToCalendarTime
            [MethodId(100)]
            Result ToCalendarTime(
                Out<nn.time.CalendarTime> outCalendarTime,
                Out<nn.time.sf.CalendarAdditionalInfo> outCalendarAdditionalInfo,
                nn.time.PosixTime posixTime,
                [BufferTransferMode(BufferTransferMode.MapAlias)] nn.time.TimeZoneRule rule);

            [MethodId(101)]
            Result ToCalendarTimeWithMyRule(
                Out<nn.time.CalendarTime> outCalendarTime,
                Out<nn.time.sf.CalendarAdditionalInfo> outCalendarAdditionalInfo,
                nn.time.PosixTime posixTime);

            // ToPosixTime
            [MethodId(201)]
            Result ToPosixTime(
                Out<int32_t> outCount,
                OutArray<nn.time.PosixTime> outPosixTimeList,
                nn.time.CalendarTime calendarTime,
                [BufferTransferMode(BufferTransferMode.MapAlias)] nn.time.TimeZoneRule rule);

            [MethodId(202)]
            Result ToPosixTimeWithMyRule(
                Out<int32_t> outCount,
                OutArray<nn.time.PosixTime> outPosixTimeList,
                nn.time.CalendarTime calendarTime);
        }
    }
}
