﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;

namespace nn
{
    namespace timesrv.detail.service
    {
        [CppRefPath("<nn/timesrv/detail/service/timesrv_ISteadyClock.sfdl.h>")]
        public interface ISteadyClock : IServiceObject
        {
            [MethodId(0)]
            Result GetCurrentTimePoint(Out<nn.time.SteadyClockTimePoint> outSteadyClockTimePoint);

            [MethodId(2)]
            Result GetTestOffset(Out<nn.TimeSpanType> outTestOffset);

            [MethodId(3)]
            Result SetTestOffset(nn.TimeSpanType testOffset);

            // デバッグ用
            [MethodId(100)]
            Result GetRtcValue(Out<int64_t> outValue);

            [MethodId(101)]
            Result IsRtcResetDetected(Out<bool> outValue);

            [MethodId(102)]
            Result GetSetupResutltValue(Out<uint32_t> outValue);

            // 特別補正向け
            [MethodId(200)]
            Result GetInternalOffset(Out<nn.TimeSpanType> outInternalOffset);

            // SIGLO-68132 にて廃止
            //[MethodId(201)]
            //Result SetInternalOffset(nn.TimeSpanType internalOffset);

        }
    }
}
