﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/timesrv/detail/core/timesrv_PmicApi-hardware.nx.h>

#include <nn/time.h>
#include <nn/time/time_ResultPrivate.h>

#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/bpc/bpc.h>
#include <nn/bpc/bpc_Rtc.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{

namespace
{
    void InitializeBpc() NN_NOEXCEPT
    {
        static bool s_IsBpcInitialized = false;
        if (s_IsBpcInitialized)
        {
            return;
        }

        // bpc サーバと timesrv が同じプロセスにいる場合、先に nn::bpc::InitializeRtcWith が呼ばれていることを期待
        // (IPC セッションを無駄遣いしないため)
        nn::bpc::InitializeRtc();
        s_IsBpcInitialized = true;
    }
}

Result RequestPmicSeconds(int64_t* pOutSeconds) NN_NOEXCEPT
{
    InitializeBpc();
    return nn::bpc::GetRtcTime(pOutSeconds);
}

bool IsPmicRtcResetDetected() NN_NOEXCEPT
{
    InitializeBpc();

    bool isDetected = nn::bpc::GetRtcResetDetected();
    // NN_DETAIL_TIME_INFO("[TIMESRV] m_StandardSteadyClockCore.IsRtcResetDetected:%s, board:%s\n",
    //     isDetected ? "true" : "false", boardType);
    return isDetected;
}

void ClearPmicRtcResetDetected() NN_NOEXCEPT
{
    InitializeBpc();

    nn::bpc::ClearRtcResetDetected();
}

}
}
}
}

