﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/time/time_StandardNetworkSystemClockPrivilegeApi.h>

#include <nn/time/detail/time_CommonDetail.h>

#include <nn/timesrv/detail/service/timesrv_ISystemClock.sfdl.h>

#include <nn/sf/sf_ISharedObject.h>

namespace nn
{
namespace time
{

extern Result GetStandardNetworkSystemClockService(
    nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>* pOut) NN_NOEXCEPT;

// System権限がないと成功しない特権API
Result SetStandardNetworkSystemClockCurrentTime(const PosixTime& posixTime) NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock> pClock;
    NN_RESULT_DO(GetStandardNetworkSystemClockService(&pClock));

    NN_RESULT_DO(pClock->SetCurrentTime(posixTime));

    NN_RESULT_SUCCESS;
}

// System権限がないと成功しない特権API
Result SetStandardNetworkSystemClockContext(const SystemClockContext& clockContext) NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock> pClock;
    NN_RESULT_DO(GetStandardNetworkSystemClockService(&pClock));

    NN_RESULT_DO(pClock->SetSystemClockContext(clockContext));

    NN_RESULT_SUCCESS;
}

}
}

