﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/time/detail/service/time_ServiceProviderClient.h>

#include <nn/timesrv/detail/service/timesrv_ServiceNames.h>
#include <nn/timesrv/detail/service/timesrv_HipcServerManager.h>

#include <nn/nn_Abort.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/nn_SystemThreadDefinition.h>

namespace nn
{
namespace time
{
namespace detail
{
namespace service
{

ServiceProviderClient::ServiceProviderClient() NN_NOEXCEPT
{
#if NN_DETAIL_TIME_CONFIG_SERVER_MODEL == NN_DETAIL_TIME_CONFIG_SERVER_MODEL_THREAD
#if NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC

#elif NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC

    static const size_t ThreadStackSize = 4 * 1024;
    static NN_OS_ALIGNAS_THREAD_STACK char g_ThreadStackBuffer[ThreadStackSize];

    NN_ABORT_UNLESS_RESULT_SUCCESS( nn::os::CreateThread(&m_ThreadType, ServerManagerThreadFunction, this, &g_ThreadStackBuffer, ThreadStackSize, NN_SYSTEM_THREAD_PRIORITY(time, IpcServer)) );
    nn::os::SetThreadNamePointer(&m_ThreadType, NN_SYSTEM_THREAD_NAME(time, IpcServer));
    nn::os::StartThread(&m_ThreadType);
#endif
#endif
}

ServiceProviderClient::~ServiceProviderClient() NN_NOEXCEPT
{
}

#if NN_DETAIL_TIME_CONFIG_SERVER_MODEL == NN_DETAIL_TIME_CONFIG_SERVER_MODEL_THREAD
#if NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
void ServiceProviderClient::ServerManagerThreadFunction(void* pContext) NN_NOEXCEPT
{
    reinterpret_cast<ServiceProviderClient*>(pContext)->m_ServiceProvider.Start();
}
#endif
#endif

#if NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC
Result ServiceProviderClient::GetUserStaticServiceSharedPointer(
    nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService>* pStaticService) NN_NOEXCEPT
{
    m_ServiceProvider.m_HipcServerManager.GetStaticServiceSharedPointer(pStaticService);
    NN_RESULT_SUCCESS;
}

Result ServiceProviderClient::GetAdminStaticServiceSharedPointer(
    nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService>* pStaticService) NN_NOEXCEPT
{
    m_ServiceProvider.m_HipcServerManager.GetStaticServiceSharedPointer(pStaticService);
    NN_RESULT_SUCCESS;
}

Result ServiceProviderClient::GetSystemStaticServiceSharedPointer(
    nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService>* pStaticService) NN_NOEXCEPT
{
    m_ServiceProvider.m_HipcServerManager.GetStaticServiceSharedPointer(pStaticService);
    NN_RESULT_SUCCESS;
}

Result ServiceProviderClient::GetRepairStaticServiceSharedPointer(
    nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService>* pStaticService) NN_NOEXCEPT
{
    m_ServiceProvider.m_HipcServerManager.GetStaticServiceSharedPointer(pStaticService);
    NN_RESULT_SUCCESS;
}

void ServiceProviderClient::Finalize() NN_NOEXCEPT
{
}

#elif NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC

namespace {
    // time_Api.cpp の以下サービスオブジェクト5つ分は確保する可能性がある
    //   - g_pStaticService = nullptr;
    //   - g_pStandardNetworkSystemClock = nullptr;
    //   - g_pStandardSteadyClock = nullptr;
    //   - g_pTimeZoneService = nullptr;
    //   - g_pEphemeralNetworkSystemClock = nullptr;
    nn::sf::SimpleAllInOneHipcSubDomainClientManager<5> g_Manager = NN_SF_SIMPLE_ALL_IN_ONE_HIPC_SUB_DOMAIN_CLIENT_MANAGER_INITIALIZER;
    nn::sf::ShimLibraryObjectHolder<nn::timesrv::detail::service::IStaticService> g_Holder = NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER;
}

Result ServiceProviderClient::GetUserStaticServiceSharedPointer(
    nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService>* pStaticService) NN_NOEXCEPT
{
    NN_RESULT_DO(g_Manager.InitializeShimLibraryHolder(&g_Holder, nn::timesrv::detail::service::UserServiceName));
    *pStaticService = g_Holder.GetObject();
    NN_RESULT_SUCCESS;
}

Result ServiceProviderClient::GetAdminStaticServiceSharedPointer(
    nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService>* pStaticService) NN_NOEXCEPT
{
    NN_RESULT_DO(g_Manager.InitializeShimLibraryHolder(&g_Holder, nn::timesrv::detail::service::AdminServiceName));
    *pStaticService = g_Holder.GetObject();
    NN_RESULT_SUCCESS;
}

Result ServiceProviderClient::GetSystemStaticServiceSharedPointer(
    nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService>* pStaticService) NN_NOEXCEPT
{
    NN_RESULT_DO(g_Manager.InitializeShimLibraryHolder(&g_Holder, nn::timesrv::detail::service::SystemServiceName));
    *pStaticService = g_Holder.GetObject();
    NN_RESULT_SUCCESS;
}

Result ServiceProviderClient::GetRepairStaticServiceSharedPointer(
    nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService>* pStaticService) NN_NOEXCEPT
{
    NN_RESULT_DO(g_Manager.InitializeShimLibraryHolder(&g_Holder, nn::timesrv::detail::service::RepairServiceName));
    *pStaticService = g_Holder.GetObject();
    NN_RESULT_SUCCESS;
}

void ServiceProviderClient::Finalize() NN_NOEXCEPT
{
    g_Holder.FinalizeHolder();
}

#endif

}
}
}
}
